/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.quickperf.perfrecording.ExtractablePerfRecorderParametersFromAnnotation;
import org.quickperf.sql.annotation.ProfileConnection;
import org.quickperf.sql.connection.AnnotationProfilingParameters;
import org.quickperf.sql.connection.ProfilingParameters;
import org.quickperf.sql.connection.stack.JUnit4StackTraceFilter;
import org.quickperf.sql.connection.stack.JUnit5StackTraceFilter;
import org.quickperf.sql.connection.stack.QuickPerfSpringStackTraceTraceFilter;
import org.quickperf.sql.connection.stack.QuickPerfStackTraceTraceFilter;
import org.quickperf.sql.connection.stack.StackTrace;
import org.quickperf.sql.connection.stack.StackTraceDisplayConfig;
import org.quickperf.sql.connection.stack.StackTraceFilter;
import org.quickperf.sql.connection.stack.TestNGStackTraceFilter;
import org.quickperf.sql.framework.ClassPath;
import org.quickperf.writer.PrintWriterBuilder;
import org.quickperf.writer.WriterFactory;

public class ProfilingParamsExtractor
implements ExtractablePerfRecorderParametersFromAnnotation<ProfileConnection, AnnotationProfilingParameters> {
    public AnnotationProfilingParameters extractFrom(ProfileConnection annotation) {
        Class<? extends WriterFactory> writerFactoryClass = annotation.writerFactory();
        PrintWriter printWriter = PrintWriterBuilder.INSTANCE.buildPrintWriterFrom(writerFactoryClass);
        StackTraceDisplayConfig stacktracedisplayConfig = this.buildStackTraceDisplayConfigFrom(annotation);
        ProfilingParameters profilingParameters = new ProfilingParameters(annotation.level(), stacktracedisplayConfig, printWriter);
        return new AnnotationProfilingParameters(profilingParameters, annotation.beforeAndAfterTestMethodExecution());
    }

    private StackTraceDisplayConfig buildStackTraceDisplayConfigFrom(ProfileConnection annotation) {
        if (annotation.displayStackTrace()) {
            Collection<StackTraceFilter> stackTraceFilters = this.buildStackTraceFilters(annotation);
            StackTrace.StackDepth stackDepth = this.extractStackDepthFrom(annotation);
            return StackTraceDisplayConfig.of(stackDepth, stackTraceFilters);
        }
        return StackTraceDisplayConfig.noStackTrace();
    }

    private Collection<StackTraceFilter> buildStackTraceFilters(ProfileConnection annotation) {
        if (annotation.filterStackTrace()) {
            return this.buildStackTraceFilters();
        }
        return Collections.emptyList();
    }

    private Collection<StackTraceFilter> buildStackTraceFilters() {
        ArrayList<StackTraceFilter> stackTraceFilters = new ArrayList<StackTraceFilter>();
        stackTraceFilters.add(QuickPerfStackTraceTraceFilter.INSTANCE);
        if (ClassPath.INSTANCE.containsSpringCore()) {
            stackTraceFilters.add(QuickPerfSpringStackTraceTraceFilter.INSTANCE);
        }
        stackTraceFilters.add(JUnit4StackTraceFilter.INSTANCE);
        stackTraceFilters.add(JUnit5StackTraceFilter.INSTANCE);
        stackTraceFilters.add(TestNGStackTraceFilter.INSTANCE);
        return stackTraceFilters;
    }

    private StackTrace.StackDepth extractStackDepthFrom(ProfileConnection annotation) {
        short annotationStackDepth = annotation.stackDepth();
        if (annotationStackDepth == -1) {
            return StackTrace.StackDepth.ALL;
        }
        return new StackTrace.StackDepth(annotationStackDepth);
    }
}

