/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection;

import java.io.PrintWriter;
import java.sql.Connection;
import org.quickperf.sql.connection.stack.StackTraceDisplayConfig;
import org.quickperf.sql.connection.stack.StackTracerPrinter;

public class ConnectionProfiler {
    private final StackTraceDisplayConfig stacktracedisplayConfig;
    private final PrintWriter printWriter;
    private final StackTracerPrinter stackTracerPrinter;
    private boolean enabled;

    ConnectionProfiler(StackTraceDisplayConfig stacktracedisplayConfig, PrintWriter printWriter) {
        this.stacktracedisplayConfig = stacktracedisplayConfig;
        this.printWriter = printWriter;
        this.stackTracerPrinter = new StackTracerPrinter(printWriter);
    }

    void enables() {
        this.enabled = true;
    }

    void disables() {
        this.enabled = false;
    }

    void profile(Connection connection, String eventDescription) {
        if (this.enabled) {
            this.printConnectionEvent(connection, eventDescription);
            if (this.stacktracedisplayConfig.isStackTraceDisplayed()) {
                this.printStackTrace();
            }
        }
    }

    private void printConnectionEvent(Connection connection, String eventDescription) {
        String connectionDescription = this.buildConnectionDescription(connection);
        String eventText = connectionDescription + " - " + eventDescription;
        this.printWriter.println(eventText);
        this.printWriter.flush();
    }

    private void printStackTrace() {
        StackTraceElement[] currentStackTrace = this.findCurrentStackTrace();
        StackTraceElement[] stackTraceToDisplay = this.stacktracedisplayConfig.format(currentStackTrace);
        this.stackTracerPrinter.printStackTrace(stackTraceToDisplay);
    }

    private StackTraceElement[] findCurrentStackTrace() {
        Thread currentThead = Thread.currentThread();
        return currentThead.getStackTrace();
    }

    private String buildConnectionDescription(Connection connection) {
        return "connection " + this.computeIdentifier(connection);
    }

    private int computeIdentifier(Connection connection) {
        return connection.hashCode();
    }
}

