/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.quickperf.SystemProperties;
import org.quickperf.sql.connection.ConnectionListener;

public class ConnectionListenerRegistry {
    public static final ConnectionListenerRegistry INSTANCE = new ConnectionListenerRegistry();
    private final Collection<ConnectionListener> connectionListenersOfTestJvm = new ArrayList<ConnectionListener>();
    private static final ThreadLocal<Map<Class<? extends ConnectionListener>, ConnectionListener>> CONNECTION_LISTENER_BY_TYPE_WHEN_ONE_JVM = new InheritableThreadLocal<Map<Class<? extends ConnectionListener>, ConnectionListener>>(){

        @Override
        protected Map<Class<? extends ConnectionListener>, ConnectionListener> initialValue() {
            return new HashMap<Class<? extends ConnectionListener>, ConnectionListener>();
        }
    };

    private ConnectionListenerRegistry() {
    }

    public void register(ConnectionListener connectionListener) {
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            this.connectionListenersOfTestJvm.add(connectionListener);
        } else {
            Map<Class<? extends ConnectionListener>, ConnectionListener> connectionListenerByType = CONNECTION_LISTENER_BY_TYPE_WHEN_ONE_JVM.get();
            connectionListenerByType.put(connectionListener.getClass(), connectionListener);
        }
    }

    public static void unregister(ConnectionListener connectionListener) {
        if (!((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            Map<Class<? extends ConnectionListener>, ConnectionListener> connectionListenerByType = CONNECTION_LISTENER_BY_TYPE_WHEN_ONE_JVM.get();
            connectionListenerByType.remove(connectionListener);
        }
    }

    public Collection<ConnectionListener> getConnectionListeners() {
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            return this.connectionListenersOfTestJvm;
        }
        Map<Class<? extends ConnectionListener>, ConnectionListener> connectionListenerByType = CONNECTION_LISTENER_BY_TYPE_WHEN_ONE_JVM.get();
        return connectionListenerByType.values();
    }

    public void clear() {
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            this.connectionListenersOfTestJvm.clear();
        }
        CONNECTION_LISTENER_BY_TYPE_WHEN_ONE_JVM.remove();
    }

    public <T extends ConnectionListener> T getConnectionListenerOfType(Class<T> type) {
        Map<Class<? extends ConnectionListener>, ConnectionListener> connectionListenerByType = CONNECTION_LISTENER_BY_TYPE_WHEN_ONE_JVM.get();
        return (T)((ConnectionListener)type.cast(connectionListenerByType.get(type)));
    }
}

