/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.quickperf.TestExecutionContext;
import org.quickperf.WorkingFolder;
import org.quickperf.measure.BooleanMeasure;
import org.quickperf.perfrecording.RecordablePerformance;
import org.quickperf.repository.BooleanMeasureRepository;
import org.quickperf.sql.connection.ConnectionListener;
import org.quickperf.sql.connection.ConnectionListenerRegistry;

public class ConnectionLeakListener
extends ConnectionListener
implements RecordablePerformance<BooleanMeasure> {
    private final List<Connection> connections = new ArrayList<Connection>();
    private BooleanMeasure connectionLeak;
    private static final String CONNECTION_LEAK_FILE_NAME = "connection-leak.ser";

    @Override
    public void theDatasourceGetsTheConnection(Connection connection) {
        this.connections.add(connection);
    }

    @Override
    public void close(Connection connection) {
        this.connections.remove(connection);
    }

    public void startRecording(TestExecutionContext testExecutionContext) {
        this.connections.clear();
        ConnectionListenerRegistry.INSTANCE.register(this);
    }

    public void stopRecording(TestExecutionContext testExecutionContext) {
        ConnectionListenerRegistry.unregister(this);
        this.connectionLeak = BooleanMeasure.of((!this.connections.isEmpty() ? 1 : 0) != 0);
        this.connections.clear();
        if (testExecutionContext.testExecutionUsesTwoJVMs()) {
            WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
            BooleanMeasureRepository.INSTANCE.save(this.connectionLeak, workingFolder, CONNECTION_LEAK_FILE_NAME);
        }
    }

    public BooleanMeasure findRecord(TestExecutionContext testExecutionContext) {
        if (testExecutionContext.testExecutionUsesTwoJVMs()) {
            WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
            return BooleanMeasureRepository.INSTANCE.find(workingFolder, CONNECTION_LEAK_FILE_NAME);
        }
        return this.connectionLeak;
    }

    public void cleanResources() {
    }
}

