/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.quickperf.sql.connection.ConnectionListener;
import org.quickperf.sql.connection.ConnectionProfiler;
import org.quickperf.sql.connection.Level;
import org.quickperf.sql.connection.ProfilingParameters;
import org.quickperf.sql.connection.stack.StackTraceDisplayConfig;

public class ConnectionEventsProfiler
extends ConnectionListener {
    private static final String CONNECTION_CLASS_NAME = "java.sql.Connection";
    private final ProfilingParameters profilingParameters;
    private final ConnectionProfiler profiler;

    public ConnectionEventsProfiler(ProfilingParameters profilingParameters) {
        this.profilingParameters = profilingParameters;
        PrintWriter printWriter = profilingParameters.getPrintWriter();
        StackTraceDisplayConfig stacktracedisplayConfig = profilingParameters.getStackTraceDisplayConfig();
        this.profiler = new ConnectionProfiler(stacktracedisplayConfig, printWriter);
    }

    public void start() {
        this.profiler.enables();
    }

    public void stop() {
        this.profiler.disables();
    }

    @Override
    public void theDatasourceGetsTheConnection(Connection connection) {
        this.profiler.profile(connection, "javax.sql.DataSource.getConnection()");
    }

    @Override
    public void theDatasourceGetsTheConnectionWithUserNameAndPassword(Connection connection) {
        this.profiler.profile(connection, "javax.sql.DataSource.getConnection(String username, String password)");
    }

    @Override
    public void close(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("close()", new String[0]);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void createStatement(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("createStatement", new String[0]);
        this.profileForTraceLevel(connection, eventDescription);
    }

    private void profileForTraceLevel(Connection connection, String text) {
        if (this.profilingParameters.getLevel() == Level.TRACE) {
            this.profiler.profile(connection, text);
        }
    }

    @Override
    public void prepareStatement(Connection connection, String sql) {
        String eventDescription = this.buildConnectionMethodDescription("prepareStatement(String sql)", "sql", sql);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void prepareCall(Connection connection, String sql) {
        String eventDescription = this.buildConnectionMethodDescription("prepareCall(String sql)", "sql", sql);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void nativeSQL(Connection connection, String sql) {
        String eventDescription = this.buildConnectionMethodDescription("nativeSQL(String sql)", "sql", sql);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void setAutoCommit(Connection connection, boolean autoCommit) {
        String eventDescription = this.buildConnectionMethodDescription("setAutoCommit(boolean autoCommit)", "autoCommit", "" + autoCommit);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void commit(Connection connection) {
        String transactionIsolationAsString = this.extractTransactionIsolationOf(connection);
        String eventDescription = this.buildConnectionMethodDescription("commit()", "isolation", transactionIsolationAsString);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void rollback(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("rollback()", new String[0]);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void setReadOnly(Connection connection, boolean readOnly) {
        String eventDescription = this.buildConnectionMethodDescription("setReadOnly(boolean readOnly)", "readOnly", "" + readOnly);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void setCatalog(Connection connection, String catalog) {
        String eventDescription = this.buildConnectionMethodDescription("setCatalog(Connection connection, String catalog)", "catalog", "" + catalog);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void setTransactionIsolation(Connection connection, int level) {
        String transactionIsolationAsString = this.extractTransactionIsolationOf(connection);
        String eventDescription = this.buildConnectionMethodDescription("setTransactionIsolation(int level)", "level", "" + level + " (" + transactionIsolationAsString + ")");
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void clearWarnings(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("clearWarnings()", new String[0]);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void createStatement(Connection connection, int resultSetType, int resultSetConcurrency) {
        String methodNameWithArguments = "createStatement(int resultSetType, int resultSetConcurrency)";
        String[] additionalInfo = new String[]{"resultSetType", "" + resultSetType, "resultSetConcurrency", "" + resultSetConcurrency};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void prepareStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) {
        String methodNameWithArguments = "prepareStatement(String sql, int resultSetType, int resultSetConcurrency)";
        String[] additionalInfo = new String[]{"sql", "" + sql, "resultSetType", "" + resultSetType, "resultSetConcurrency", "" + resultSetConcurrency};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void prepareCall(Connection connection, String sql, int resultSetType, int resultSetConcurrency) {
        String methodNameWithArguments = "prepareCall(String sql, int resultSetType, int resultSetConcurrency)";
        String[] additionalInfo = new String[]{"sql", "" + sql, "resultSetType", "" + resultSetType, "resultSetConcurrency", "" + resultSetConcurrency};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void setTypeMap(Connection connection, Map<String, Class<?>> map) {
        String methodNameWithArguments = "setTypeMap(Map<String, Class<?>> map)";
        String[] additionalInfo = new String[]{"map", "" + map};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void setHoldability(Connection connection, int holdability) {
        String methodNameWithArguments = "setHoldability(int holdability)";
        String[] additionalInfo = new String[]{"holdability", "" + holdability};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void setSavepoint(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("setSavepoint()", new String[0]);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void setSavepoint(Connection connection, String name) {
        String methodNameWithArguments = "setSavepoint(String name)";
        String[] additionalInfo = new String[]{"name", "" + name};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void rollback(Connection connection, Savepoint savepoint) {
        String methodNameWithArguments = "rollback(Savepoint savepoint)";
        String[] additionalInfo = new String[]{"savepoint", "" + savepoint};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void releaseSavepoint(Connection connection, Savepoint savepoint) {
        String methodNameWithArguments = "releaseSavepoint(Savepoint savepoint)";
        String[] additionalInfo = new String[]{"savepoint", "" + savepoint};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void createStatement(Connection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        String methodNameWithArguments = "createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)";
        String[] additionalInfo = new String[]{"resultSetType", "" + resultSetType + "resultSetConcurrency", "" + resultSetConcurrency + "resultSetHoldability", "" + resultSetHoldability};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void prepareStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        String methodNameWithArguments = "prepareStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)";
        String[] additionalInfo = new String[]{"resultSetType", "" + resultSetType + "resultSetConcurrency", "" + resultSetConcurrency + "resultSetHoldability", "" + resultSetHoldability};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void prepareCall(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        String methodNameWithArguments = "prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)";
        String[] additionalInfo = new String[]{"resultSetType", "" + resultSetType + "resultSetConcurrency", "" + resultSetConcurrency + "resultSetHoldability", "" + resultSetHoldability};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void prepareStatement(Connection connection, String sql, int autoGeneratedKeys) {
        String methodNameWithArguments = "prepareStatement(String sql, int autoGeneratedKeys)";
        String[] additionalInfo = new String[]{"sql", "" + sql + "autoGeneratedKeys", "" + autoGeneratedKeys};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void prepareStatement(Connection connection, String sql, int[] columnIndexes) {
        String methodNameWithArguments = "prepareStatement(String sql, int[] columnIndexes)";
        String[] additionalInfo = new String[]{"sql", "" + sql + "columnIndexes", "" + Arrays.toString(columnIndexes)};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void prepareStatement(Connection connection, String sql, String[] columnNames) {
        String methodNameWithArguments = "prepareStatement(String sql, String[] columnNames)";
        String[] additionalInfo = new String[]{"sql", "" + sql + "columnNames", "" + Arrays.toString(columnNames)};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void createClob(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("createClob()", new String[0]);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void createBlob(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("createBlob()", new String[0]);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void createNClob(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("createNClob()", new String[0]);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void createSQLXML(Connection connection) {
        String eventDescription = this.buildConnectionMethodDescription("createSQLXML()", new String[0]);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void setClientInfo(Connection connection, String name, String value) {
        String methodNameWithArguments = "setClientInfo(String name, String value)";
        String[] additionalInfo = new String[]{"name", "" + name + "value", "" + value};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void setClientInfo(Connection connection, Properties properties) {
        String methodNameWithArguments = "setClientInfo(Properties properties)";
        String[] additionalInfo = new String[]{"properties", "" + properties};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void createArrayOf(Connection connection, String typeName, Object[] elements) {
        String methodNameWithArguments = "createArrayOf(String typeName, Object[] elements)";
        String[] additionalInfo = new String[]{"typeName", "" + typeName + "elements", "" + Arrays.toString(elements)};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void createStruct(Connection connection, String typeName, Object[] attributes) {
        String methodNameWithArguments = "createStruct(String typeName, Object[] attributes)";
        String[] additionalInfo = new String[]{"typeName", "" + typeName + "attributes", "" + Arrays.toString(attributes)};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profileForTraceLevel(connection, eventDescription);
    }

    @Override
    public void setSchema(Connection connection, String schema) {
        String methodNameWithArguments = "setSchema(String schema)";
        String[] additionalInfo = new String[]{"schema", "" + schema};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void abort(Connection connection, Executor executor) {
        String eventDescription = this.buildConnectionMethodDescription("abort(Executor executor)", new String[0]);
        this.profiler.profile(connection, eventDescription);
    }

    @Override
    public void setNetworkTimeout(Connection connection, Executor executor, int milliseconds) {
        String methodNameWithArguments = "setNetworkTimeout(Executor executor, int milliseconds)";
        String[] additionalInfo = new String[]{"milliseconds", "" + milliseconds};
        String eventDescription = this.buildConnectionMethodDescription(methodNameWithArguments, additionalInfo);
        this.profiler.profile(connection, eventDescription);
    }

    private String extractTransactionIsolationOf(Connection connection) {
        try {
            int transactionIsolation = connection.getTransactionIsolation();
            return this.formatTransactionIsolationAsString(transactionIsolation);
        }
        catch (SQLException sqlException) {
            return "";
        }
    }

    private String buildConnectionMethodDescription(String methodNameWithArguments, String ... additionalData) {
        String additionalInfo = this.buildAdditionalInfoAsString(additionalData);
        return "java.sql.Connection." + methodNameWithArguments + (additionalInfo.isEmpty() ? "" : " [" + additionalInfo + "]");
    }

    private String formatTransactionIsolationAsString(int transactionIsolation) {
        if (transactionIsolation == 0) {
            return "transaction_none";
        }
        if (transactionIsolation == 1) {
            return "transaction_read_uncommitted";
        }
        if (transactionIsolation == 2) {
            return "transaction_read_committed";
        }
        if (transactionIsolation == 8) {
            return "transaction_serializable";
        }
        return "";
    }

    private String buildAdditionalInfoAsString(String[] additionalData) {
        StringBuilder additionalInfoBuilder = new StringBuilder();
        boolean isLabel = true;
        int lastDatumIndex = additionalData.length;
        for (int i = 0; i < lastDatumIndex; ++i) {
            String labelOrDescription = additionalData[i];
            additionalInfoBuilder.append(labelOrDescription);
            if (isLabel) {
                additionalInfoBuilder.append(": ");
            } else if (i != additionalData.length - 1) {
                additionalInfoBuilder.append(", ");
            }
            isLabel = !isLabel;
        }
        return additionalInfoBuilder.toString();
    }
}

