/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.bindparams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ttddyy.dsproxy.QueryInfo;
import org.quickperf.ExtractablePerformanceMeasure;
import org.quickperf.measure.BooleanMeasure;
import org.quickperf.sql.SqlExecution;
import org.quickperf.sql.SqlExecutions;

public class AllParametersAreBoundExtractor
implements ExtractablePerformanceMeasure<SqlExecutions, BooleanMeasure> {
    public static final AllParametersAreBoundExtractor INSTANCE = new AllParametersAreBoundExtractor();

    private AllParametersAreBoundExtractor() {
    }

    public BooleanMeasure extractPerfMeasureFrom(SqlExecutions sqlExecutions) {
        for (SqlExecution sqlExecution : sqlExecutions) {
            for (QueryInfo query : sqlExecution.getQueries()) {
                if (!this.oneUnbindParameter(query)) continue;
                return BooleanMeasure.FALSE;
            }
        }
        return BooleanMeasure.TRUE;
    }

    private boolean oneUnbindParameter(QueryInfo query) {
        String queryString = query.getQuery();
        String queryStrippedOfQuotes = this.stripQuotesContent(queryString);
        String queryInLowerCase = queryStrippedOfQuotes.toLowerCase();
        if (SqlKeyWord.hasConditions(queryInLowerCase)) {
            List<String> conditions = SqlKeyWord.extractConditions(queryInLowerCase);
            for (String condition : conditions) {
                SqlKeyWord sqlKeyWord = SqlKeyWord.wherePartSplitter(condition);
                if (!sqlKeyWord.hasUnBindParameter(condition)) continue;
                return true;
            }
        }
        return false;
    }

    private String stripQuotesContent(String queryString) {
        String[] queryElements = queryString.split("");
        String queryStrippedOfQuotes = "";
        boolean isBetweenQuotes = false;
        for (String queryElement : queryElements) {
            if (queryElement.equals("'")) {
                isBetweenQuotes = !isBetweenQuotes;
                continue;
            }
            if (isBetweenQuotes) continue;
            queryStrippedOfQuotes = queryStrippedOfQuotes + queryElement;
        }
        return queryStrippedOfQuotes;
    }

    private static enum SqlKeyWord {
        IN("in"){

            @Override
            boolean hasUnBindParameter(String andOrPart) {
                if (1.isReferencedNestedStatement(andOrPart)) {
                    return false;
                }
                return 1.hasUnBindParameter(IN, andOrPart);
            }
        }
        ,
        VALUES("values"){

            @Override
            boolean hasUnBindParameter(String andOrPart) {
                return 2.hasUnBindParameter(VALUES, andOrPart);
            }
        }
        ,
        SET("set"){

            @Override
            boolean hasUnBindParameter(String andOrPart) {
                return 3.hasUnBindParameter(SET, andOrPart);
            }
        }
        ,
        OTHER("other"){

            @Override
            boolean hasUnBindParameter(String andOrPart) {
                if (4.isReferencedNestedStatement(andOrPart = andOrPart.replaceAll(" ", ""))) {
                    return false;
                }
                if (this.isJoinWithWhereUsed(andOrPart)) {
                    return false;
                }
                return SqlKeyWord.isUnbindParameter(andOrPart);
            }

            private boolean isJoinWithWhereUsed(String andOrPart) {
                String[] equalParts = andOrPart.split("=");
                return equalParts[0].contains(".") && equalParts.length == 2 && equalParts[1].contains(".");
            }
        };

        private final String keyWord;

        private static boolean isUnbindParameter(String parameter) {
            return !parameter.contains("?");
        }

        private SqlKeyWord(String keyWord) {
            this.keyWord = keyWord;
        }

        static SqlKeyWord wherePartSplitter(String word) {
            for (SqlKeyWord sqlKeyWord : SqlKeyWord.values()) {
                if (word.split(" " + sqlKeyWord.getValue() + " ").length <= 1) continue;
                return sqlKeyWord;
            }
            return OTHER;
        }

        public String getValue() {
            return this.keyWord;
        }

        static boolean isReferencedNestedStatement(String andOrPart) {
            return andOrPart.contains("select") || andOrPart.contains("delete");
        }

        static boolean hasConditions(String queryInLowerCase) {
            return queryInLowerCase.contains("where") || queryInLowerCase.contains("values") || queryInLowerCase.contains("set");
        }

        static List<String> extractConditions(String queryInLowerCase) {
            String[] whereParts = queryInLowerCase.split("where");
            ArrayList<String> conditions = new ArrayList<String>();
            for (String wherePart : whereParts) {
                String[] andOrPart = wherePart.split(" and | or ");
                Collections.addAll(conditions, andOrPart);
            }
            return conditions;
        }

        static boolean hasUnBindParameter(SqlKeyWord sqlKeyWord, String andOrPart) {
            String[] commaParts;
            String[] sqlKeyWordParts = andOrPart.split(sqlKeyWord.getValue());
            for (String part : commaParts = sqlKeyWordParts[1].split(",")) {
                if (!SqlKeyWord.isUnbindParameter(part)) continue;
                return true;
            }
            return false;
        }

        abstract boolean hasUnBindParameter(String var1);
    }
}

