/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.analyze;

import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import net.ttddyy.dsproxy.QueryType;
import org.quickperf.sql.SqlExecution;
import org.quickperf.sql.SqlExecutions;
import org.quickperf.sql.bindparams.AllParametersAreBoundExtractor;
import org.quickperf.sql.execution.SqlAnalysis;
import org.quickperf.sql.framework.JdbcSuggestion;
import org.quickperf.sql.like.ContainsLikeWithLeadingWildcardExtractor;
import org.quickperf.sql.select.analysis.SelectAnalysis;
import org.quickperf.time.ExecutionTime;

public class SqlReport {
    private static final String HEADER = System.lineSeparator() + "[QUICK PERF] SQL ANALYSIS" + System.lineSeparator();
    private static final String EMPTY_MESSAGE = "";
    private static final String DISPLAY_SEPARATOR = "                                            * * * * *";
    private static final String ALERT_MESSAGE = "!!! WARNING !!!";
    private static final String QUERY_WITHOUT_BIND_PARAMETERS = "- Query without bind parameters";
    public static SqlReport INSTANCE = new SqlReport();

    private SqlReport() {
    }

    public void writeReport(PrintWriter writer, SqlAnalysis sqlAnalysis) {
        SqlExecutions sqlExecutions = sqlAnalysis.getSqlExecutions();
        writer.write(HEADER);
        writer.write(this.buildJdbcExecutions(sqlExecutions));
        writer.write(this.getMaxTime(sqlExecutions));
        writer.write(this.buildSelectMessages(sqlAnalysis));
        writer.write(this.buildNPlusOneMessage(sqlAnalysis));
        writer.write(this.buildInsertMessage(sqlExecutions));
        writer.write(this.buildUpdateMessage(sqlExecutions));
        writer.write(this.buildDeleteMessage(sqlExecutions));
        writer.write(this.formatQueries(sqlExecutions));
    }

    private String buildSelectMessages(SqlAnalysis sqlAnalysis) {
        if (this.numberOf(sqlAnalysis.getSqlExecutions(), QueryType.SELECT) == 0) {
            return EMPTY_MESSAGE;
        }
        SelectAnalysis selectAnalysis = sqlAnalysis.getSelectAnalysis();
        SqlExecutions selectExecutions = sqlAnalysis.getSqlExecutions().filterByQueryType(QueryType.SELECT);
        int selectCount = this.numberOf(sqlAnalysis.getSqlExecutions(), QueryType.SELECT);
        String mes = this.buildSelectCountReport(selectCount);
        if (selectAnalysis.hasSameSelects()) {
            mes = mes + "- Same SELECT statements" + System.lineSeparator();
        }
        if (this.checkIfWildcard(selectExecutions)) {
            mes = mes + "- Like with leading wildcard detected (% or _)" + System.lineSeparator();
        }
        if (this.checkIfBindParameters(selectExecutions)) {
            mes = mes + QUERY_WITHOUT_BIND_PARAMETERS + System.lineSeparator();
        }
        return mes;
    }

    private int numberOf(SqlExecutions sqlExecutions, QueryType queryType) {
        return sqlExecutions.retrieveQueryNumberOfType(queryType);
    }

    private String buildNPlusOneMessage(SqlAnalysis sqlAnalysis) {
        if (sqlAnalysis.getSelectAnalysis().getSameSelectTypesWithDifferentParamValues().evaluate()) {
            SelectAnalysis.SameSelectTypesWithDifferentParamValues sameSelectTypesWithDifferentParamValues = sqlAnalysis.getSelectAnalysis().getSameSelectTypesWithDifferentParamValues();
            return this.addSeparationString() + ALERT_MESSAGE + SelectAnalysis.getNPlusOneFrameworkMessage() + System.lineSeparator() + System.lineSeparator() + JdbcSuggestion.SERVER_ROUND_TRIPS.getMessage() + System.lineSeparator() + System.lineSeparator();
        }
        return EMPTY_MESSAGE;
    }

    private String formatQueries(SqlExecutions sqlExecutions) {
        if (sqlExecutions.getNumberOfExecutions() == 0) {
            return EMPTY_MESSAGE;
        }
        return sqlExecutions.getNumberOfExecutions() > 1 ? this.addSeparationString() + "QUERIES " + System.lineSeparator() + sqlExecutions.toString() : this.addSeparationString() + "QUERY " + System.lineSeparator() + sqlExecutions.toString();
    }

    private String buildJdbcExecutions(SqlExecutions sqlExecutions) {
        return this.addSeparationString() + "SQL EXECUTIONS: " + sqlExecutions.getNumberOfExecutions() + System.lineSeparator();
    }

    private String buildUpdateCountReport(int updateCount) {
        if (updateCount > 0) {
            return this.addSeparationString() + QueryType.UPDATE + ": " + updateCount + System.lineSeparator();
        }
        return EMPTY_MESSAGE;
    }

    private String buildInsertCountReport(int insertCount) {
        if (insertCount > 0) {
            return this.addSeparationString() + QueryType.INSERT + ": " + insertCount + System.lineSeparator();
        }
        return EMPTY_MESSAGE;
    }

    private String buildInsertMessage(SqlExecutions sqlExecutions) {
        if (this.numberOf(sqlExecutions, QueryType.INSERT) == 0) {
            return EMPTY_MESSAGE;
        }
        int insertCount = this.numberOf(sqlExecutions, QueryType.INSERT);
        String mes = this.buildInsertCountReport(insertCount);
        SqlExecutions insertExecutions = sqlExecutions.filterByQueryType(QueryType.INSERT);
        if (this.checkIfBindParameters(insertExecutions)) {
            mes = mes + QUERY_WITHOUT_BIND_PARAMETERS + System.lineSeparator();
        }
        return mes;
    }

    private String buildUpdateMessage(SqlExecutions sqlExecutions) {
        if (this.numberOf(sqlExecutions, QueryType.UPDATE) == 0) {
            return EMPTY_MESSAGE;
        }
        SqlExecutions updateExecutions = sqlExecutions.filterByQueryType(QueryType.UPDATE);
        int updateCount = this.numberOf(sqlExecutions, QueryType.UPDATE);
        String mes = this.buildUpdateCountReport(updateCount);
        if (this.checkIfBindParameters(updateExecutions)) {
            mes = mes + QUERY_WITHOUT_BIND_PARAMETERS + System.lineSeparator();
        }
        return mes;
    }

    private String buildDeleteMessage(SqlExecutions sqlExecutions) {
        if (this.numberOf(sqlExecutions, QueryType.DELETE) == 0) {
            return EMPTY_MESSAGE;
        }
        SqlExecutions updateExecutions = sqlExecutions.filterByQueryType(QueryType.DELETE);
        int deleteCount = this.numberOf(sqlExecutions, QueryType.DELETE);
        String mes = this.buildDeleteCountReport(deleteCount);
        if (this.checkIfBindParameters(updateExecutions)) {
            mes = mes + QUERY_WITHOUT_BIND_PARAMETERS + System.lineSeparator();
        }
        return mes;
    }

    private String buildSelectCountReport(int selectCount) {
        if (selectCount > 0) {
            return this.addSeparationString() + QueryType.SELECT + ": " + selectCount + System.lineSeparator();
        }
        return EMPTY_MESSAGE;
    }

    private String buildDeleteCountReport(int deleteCount) {
        if (deleteCount > 0) {
            return this.addSeparationString() + QueryType.DELETE + ": " + deleteCount + System.lineSeparator();
        }
        return EMPTY_MESSAGE;
    }

    private String getMaxTime(SqlExecutions sqlExecutions) {
        if (sqlExecutions.getNumberOfExecutions() == 0) {
            return EMPTY_MESSAGE;
        }
        long maxExecutionTime = 0L;
        for (SqlExecution execution : sqlExecutions) {
            long executionTime = execution.getElapsedTime();
            if (executionTime <= maxExecutionTime) continue;
            maxExecutionTime = executionTime;
        }
        return "MAX TIME: " + new ExecutionTime(Long.valueOf(maxExecutionTime), TimeUnit.MILLISECONDS).toString() + System.lineSeparator();
    }

    private boolean checkIfWildcard(SqlExecutions sqlExecutions) {
        return ContainsLikeWithLeadingWildcardExtractor.INSTANCE.extractPerfMeasureFrom(sqlExecutions).getValue();
    }

    private boolean checkIfBindParameters(SqlExecutions sqlExecutions) {
        return AllParametersAreBoundExtractor.INSTANCE.extractPerfMeasureFrom(sqlExecutions).getValue() == false;
    }

    private String addSeparationString() {
        return DISPLAY_SEPARATOR + System.lineSeparator();
    }
}

