/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql;

import org.quickperf.issue.PerfIssue;
import org.quickperf.unit.Count;

public class SqlStatementPerfIssueBuilder {
    private SqlStatementPerfIssueBuilder() {
    }

    public static SqlStatementPerfIssueBuilder aSqlPerfIssue() {
        return new SqlStatementPerfIssueBuilder();
    }

    public PerfIssue buildNotEqualNumberOfStatements(Count measuredCount, Count expectedCount, String requestType) {
        String description = "Expected number of " + requestType + " statements <" + expectedCount.getValue() + "> but is <" + measuredCount.getValue() + ">.";
        return new PerfIssue(description);
    }

    public String buildMaxOfStatementsDesc(Count measuredCount, Count expectedCount, String statementName) {
        boolean severalExpectedStatements = expectedCount.getValue() > 1L;
        boolean severalExecutedStatements = measuredCount.getValue() > 1L;
        return "You may think that at most <" + expectedCount.getValue() + "> " + statementName + " statement" + (severalExpectedStatements ? "s were" : " was") + " sent to the database" + System.lineSeparator() + "       But there " + (severalExecutedStatements ? "are" : "is") + " in fact <" + measuredCount.getValue() + ">...";
    }
}

