/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.quickperf.SystemProperties;
import org.quickperf.sql.SqlRecorder;

public class SqlRecorderRegistry {
    public static final SqlRecorderRegistry INSTANCE = new SqlRecorderRegistry();
    private final Map<Class<? extends SqlRecorder>, SqlRecorder> sqlRecorderByTypeOfTestJvm = new HashMap<Class<? extends SqlRecorder>, SqlRecorder>();
    private static final ThreadLocal<Map<Class<? extends SqlRecorder>, SqlRecorder>> SQL_RECORDER_BY_TYPE_WHEN_ONE_JVM = new InheritableThreadLocal<Map<Class<? extends SqlRecorder>, SqlRecorder>>(){

        @Override
        protected Map<Class<? extends SqlRecorder>, SqlRecorder> initialValue() {
            return new HashMap<Class<? extends SqlRecorder>, SqlRecorder>();
        }
    };

    private SqlRecorderRegistry() {
    }

    public void register(SqlRecorder sqlRecorder) {
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            Class<?> sqlRecorderClass = sqlRecorder.getClass();
            this.sqlRecorderByTypeOfTestJvm.put(sqlRecorderClass, sqlRecorder);
        } else {
            Map<Class<? extends SqlRecorder>, SqlRecorder> sqlRecordersBytType = SQL_RECORDER_BY_TYPE_WHEN_ONE_JVM.get();
            sqlRecordersBytType.put(sqlRecorder.getClass(), sqlRecorder);
        }
    }

    public static void unregister(SqlRecorder sqlRecorder) {
        if (!((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            Map<Class<? extends SqlRecorder>, SqlRecorder> sqlRecordersByType = SQL_RECORDER_BY_TYPE_WHEN_ONE_JVM.get();
            sqlRecordersByType.remove(sqlRecorder);
        }
    }

    public Collection<SqlRecorder> getSqlRecorders() {
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            return this.sqlRecorderByTypeOfTestJvm.values();
        }
        Map<Class<? extends SqlRecorder>, SqlRecorder> sqlRecorderByType = SQL_RECORDER_BY_TYPE_WHEN_ONE_JVM.get();
        return sqlRecorderByType.values();
    }

    public <T extends SqlRecorder> T getSqlRecorderOfType(Class<T> type) {
        Map<Class<? extends SqlRecorder>, SqlRecorder> sqlRecorderByType = SQL_RECORDER_BY_TYPE_WHEN_ONE_JVM.get();
        return (T)((SqlRecorder)type.cast(sqlRecorderByType.get(type)));
    }

    public void clear() {
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            this.sqlRecorderByTypeOfTestJvm.clear();
        }
        SQL_RECORDER_BY_TYPE_WHEN_ONE_JVM.remove();
    }
}

