/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.QueryType;
import org.quickperf.SystemProperties;
import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.PerfIssuesFormat;
import org.quickperf.perfrecording.ViewablePerfRecordIfPerfIssue;
import org.quickperf.sql.QueryTypeRetriever;
import org.quickperf.sql.SqlExecution;
import org.quickperf.sql.framework.quickperf.DataSourceConfig;
import org.quickperf.sql.update.columns.NumberOfUpdatedColumnsStatistics;

public class SqlExecutions
implements Iterable<SqlExecution>,
ViewablePerfRecordIfPerfIssue,
Serializable {
    public static final SqlExecutions NONE = new SqlExecutions();
    private final Deque<SqlExecution> sqlExecutions = new ArrayDeque<SqlExecution>();

    public void add(ExecutionInfo execInfo, List<QueryInfo> queries) {
        SqlExecution sqlExecution = new SqlExecution(execInfo, queries);
        this.sqlExecutions.addLast(sqlExecution);
    }

    private void addWithoutCall(ExecutionInfo executionInfo, List<QueryInfo> queries) {
        SqlExecution sqlExecution = new SqlExecution(executionInfo, queries, 0L);
        this.sqlExecutions.addLast(sqlExecution);
    }

    public SqlExecutions filterByQueryType(QueryType queryType) {
        SqlExecutions filteredSqlExecutions = new SqlExecutions();
        for (SqlExecution execution : this.sqlExecutions) {
            ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
            boolean added = false;
            for (QueryInfo query : execution.getQueries()) {
                if (!queryType.equals((Object)QueryTypeRetriever.INSTANCE.typeOf(query))) continue;
                added = true;
                queries.add(query);
            }
            if (!added) continue;
            filteredSqlExecutions.addWithoutCall(execution.getExecutionInfo(), queries);
        }
        return filteredSqlExecutions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SqlExecution sqlExecution : this.sqlExecutions) {
            sb.append("\t").append(sqlExecution.toString());
            sb.append(System.lineSeparator());
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this == NONE || this.sqlExecutions.isEmpty();
    }

    public int retrieveQueryNumberOfType(QueryType queryType) {
        int queryNumber = 0;
        QueryTypeRetriever queryTypeRetriever = QueryTypeRetriever.INSTANCE;
        for (SqlExecution sqlExecution : this.sqlExecutions) {
            for (QueryInfo query : sqlExecution.getQueries()) {
                if (!queryType.equals((Object)queryTypeRetriever.typeOf(query))) continue;
                ++queryNumber;
            }
        }
        return queryNumber;
    }

    public NumberOfUpdatedColumnsStatistics getUpdatedColumnsStatistics() {
        long minColumnCount = 0L;
        long maxColumnCount = 0L;
        for (SqlExecution sqlExecution : this.sqlExecutions) {
            Iterator<QueryInfo> iterator = sqlExecution.getQueries().iterator();
            while (iterator.hasNext()) {
                QueryTypeRetriever queryTypeRetriever = QueryTypeRetriever.INSTANCE;
                QueryInfo query = iterator.next();
                if (queryTypeRetriever.typeOf(query) != QueryType.UPDATE) continue;
                long updatedColumnCount = this.countUpdatedColumn(query.getQuery());
                if (minColumnCount == 0L || updatedColumnCount < minColumnCount) {
                    minColumnCount = updatedColumnCount;
                }
                if (updatedColumnCount <= maxColumnCount) continue;
                maxColumnCount = updatedColumnCount;
            }
        }
        return new NumberOfUpdatedColumnsStatistics(minColumnCount, maxColumnCount);
    }

    private long countUpdatedColumn(String sql) {
        int setIndex = sql.toLowerCase().indexOf("set");
        int whereIndex = sql.toLowerCase().indexOf("where");
        whereIndex = whereIndex > -1 ? whereIndex : sql.length();
        String sqlSetClause = sql.substring(setIndex, whereIndex);
        return this.countUnquotedEquals(sqlSetClause);
    }

    private long countUnquotedEquals(String setClause) {
        boolean inQuote = false;
        long equalCounter = 0L;
        for (char c : setClause.toCharArray()) {
            if (c == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (inQuote || c != '=') continue;
            ++equalCounter;
        }
        return equalCounter;
    }

    public long getMaxNumberOfSelectedColumns() {
        long maxNumberOfColumnsForAllExecs = 0L;
        for (SqlExecution sqlExecution : this.sqlExecutions) {
            long columnCount = sqlExecution.getColumnCount();
            if (columnCount <= maxNumberOfColumnsForAllExecs) continue;
            maxNumberOfColumnsForAllExecs = columnCount;
        }
        return maxNumberOfColumnsForAllExecs;
    }

    public String format(Collection<PerfIssue> perfIssues) {
        String standardFormatting = PerfIssuesFormat.STANDARD.format(perfIssues);
        if (((Boolean)SystemProperties.SIMPLIFIED_SQL_DISPLAY.evaluate()).booleanValue()) {
            return standardFormatting;
        }
        return standardFormatting + System.lineSeparator() + System.lineSeparator() + "[JDBC QUERY EXECUTION (executeQuery, executeBatch, ...)]" + System.lineSeparator() + (this.noJdbcExecution() ? new DataSourceConfig().getMessage() : this.toString());
    }

    private boolean noJdbcExecution() {
        return this.sqlExecutions.size() == 0;
    }

    @Override
    public Iterator<SqlExecution> iterator() {
        return this.sqlExecutions.iterator();
    }

    public int getNumberOfExecutions() {
        return this.sqlExecutions.size();
    }
}

