/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.update.columns;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.sql.annotation.ExpectUpdatedColumn;
import org.quickperf.sql.update.columns.NumberOfUpdatedColumnsStatistics;
import org.quickperf.sql.update.columns.NumberOfUpdatedColumnsStatisticsMeasure;

public class UpdatedColumnsPerfIssueVerifier
implements VerifiablePerformanceIssue<ExpectUpdatedColumn, NumberOfUpdatedColumnsStatisticsMeasure> {
    public static final UpdatedColumnsPerfIssueVerifier INSTANCE = new UpdatedColumnsPerfIssueVerifier();

    private UpdatedColumnsPerfIssueVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectUpdatedColumn annotation, NumberOfUpdatedColumnsStatisticsMeasure measure) {
        NumberOfUpdatedColumnsStatistics updatedColumnsStatistics = measure.getValue();
        int expectedUpdatesColumns = annotation.value();
        long maxColumnCount = updatedColumnsStatistics.getMax();
        long minColumnCount = updatedColumnsStatistics.getMin();
        if ((long)expectedUpdatesColumns != minColumnCount || (long)expectedUpdatesColumns != maxColumnCount) {
            return this.buildPerfIssue(expectedUpdatesColumns, maxColumnCount, minColumnCount);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(int expectedUpdatesColumns, long maxColumnCount, long minColumnCount) {
        String assertionMessage = "Expected number of updated columns <" + expectedUpdatesColumns + ">";
        boolean oneColumnUpdated = minColumnCount == maxColumnCount;
        assertionMessage = oneColumnUpdated ? assertionMessage + " but is <" + minColumnCount + ">." : assertionMessage + " but is between <" + minColumnCount + "> and <" + maxColumnCount + ">.";
        return new PerfIssue(assertionMessage);
    }
}

