/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.update.columns;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.annotation.ExpectMaxUpdatedColumn;
import org.quickperf.unit.Count;

public class MaxUpdatedColumnsPerfIssueVerifier
implements VerifiablePerformanceIssue<ExpectMaxUpdatedColumn, Count> {
    public static final MaxUpdatedColumnsPerfIssueVerifier INSTANCE = new MaxUpdatedColumnsPerfIssueVerifier();

    private MaxUpdatedColumnsPerfIssueVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxUpdatedColumn annotation, Count maxSqlCountMeasure) {
        Count expectedCount = new Count(Integer.valueOf(annotation.value()));
        if (maxSqlCountMeasure.isGreaterThan((PerfMeasure)expectedCount)) {
            return this.buildPerfIssue(maxSqlCountMeasure, expectedCount);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(Count maxSqlCountMeasure, Count expectedCount) {
        String description = "Maximum expected number of updated columns <" + expectedCount.getValue() + "> but is <" + maxSqlCountMeasure.getValue() + ">." + System.lineSeparator() + System.lineSeparator() + "The following requests were executed: " + System.lineSeparator() + maxSqlCountMeasure.getComment();
        return new PerfIssue(description);
    }
}

