/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.update;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.SqlStatementPerfIssueBuilder;
import org.quickperf.sql.annotation.ExpectMaxUpdate;
import org.quickperf.unit.Count;

public class MaxOfUpdatesPerfIssueVerifier
implements VerifiablePerformanceIssue<ExpectMaxUpdate, Count> {
    public static final MaxOfUpdatesPerfIssueVerifier INSTANCE = new MaxOfUpdatesPerfIssueVerifier();

    private MaxOfUpdatesPerfIssueVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxUpdate annotation, Count measuredCount) {
        Count expectedCount = new Count(Integer.valueOf(annotation.value()));
        if (measuredCount.isGreaterThan((PerfMeasure)expectedCount)) {
            return this.buildPerfIssue(measuredCount, expectedCount);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(Count measuredCount, Count expectedCount) {
        String description = SqlStatementPerfIssueBuilder.aSqlPerfIssue().buildMaxOfStatementsDesc(measuredCount, expectedCount, "update");
        return new PerfIssue(description);
    }
}

