/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.statement;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.BooleanMeasure;
import org.quickperf.sql.annotation.DisableStatements;

public class NoStatementVerifier
implements VerifiablePerformanceIssue<DisableStatements, BooleanMeasure> {
    public static final NoStatementVerifier INSTANCE = new NoStatementVerifier();

    private NoStatementVerifier() {
    }

    public PerfIssue verifyPerfIssue(DisableStatements annotation, BooleanMeasure noStatementExist) {
        Boolean noStatement = noStatementExist.getValue();
        if (noStatement.booleanValue()) {
            return PerfIssue.NONE;
        }
        String description = "At least one Statement. Only PreparedStatement and CallableStatement were expected.";
        return new PerfIssue(description);
    }
}

