/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.select.columns;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.annotation.ExpectSelectedColumn;
import org.quickperf.unit.Count;

public class SelectedColumnNumberPerfIssueVerifier
implements VerifiablePerformanceIssue<ExpectSelectedColumn, Count> {
    public static final SelectedColumnNumberPerfIssueVerifier INSTANCE = new SelectedColumnNumberPerfIssueVerifier();

    private SelectedColumnNumberPerfIssueVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectSelectedColumn annotation, Count measuredCount) {
        Count expectedCount = new Count(Integer.valueOf(annotation.value()));
        if (!measuredCount.isEqualTo((PerfMeasure)expectedCount)) {
            return this.buildPerfIssue(measuredCount, expectedCount);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(Count measuredCount, Count expectedCount) {
        String description = "You may think that <" + expectedCount.getValue() + "> column" + (expectedCount.getValue() > 1L ? "s were" : " was") + " selected" + System.lineSeparator() + "       But in fact <" + measuredCount.getValue() + ">...";
        return new PerfIssue(description);
    }
}

