/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.select.columns;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.annotation.ExpectMaxSelectedColumn;
import org.quickperf.unit.Count;

public class MaxSelectedColumnsPerfIssueVerifier
implements VerifiablePerformanceIssue<ExpectMaxSelectedColumn, Count> {
    public static final MaxSelectedColumnsPerfIssueVerifier INSTANCE = new MaxSelectedColumnsPerfIssueVerifier();

    private MaxSelectedColumnsPerfIssueVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxSelectedColumn annotation, Count maxSqlCountMeasure) {
        Count expectedCount = new Count(Integer.valueOf(annotation.value()));
        if (maxSqlCountMeasure.isGreaterThan((PerfMeasure)expectedCount)) {
            return this.buildPerfIssue(maxSqlCountMeasure, expectedCount);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(Count maxSqlCountMeasure, Count expectedCount) {
        String description = "Maximum expected number of selected columns <" + expectedCount.getValue() + "> but is <" + maxSqlCountMeasure.getValue() + ">." + maxSqlCountMeasure.getComment();
        return new PerfIssue(description);
    }
}

