/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.select.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.QueryType;
import org.quickperf.ExtractablePerformanceMeasure;
import org.quickperf.sql.QueryTypeRetriever;
import org.quickperf.sql.SqlExecution;
import org.quickperf.sql.SqlExecutions;
import org.quickperf.sql.select.analysis.QueryParamsExtractor;
import org.quickperf.sql.select.analysis.SelectAnalysis;

public class SelectAnalysisExtractor
implements ExtractablePerformanceMeasure<SqlExecutions, SelectAnalysis> {
    public static final SelectAnalysisExtractor INSTANCE = new SelectAnalysisExtractor();

    private SelectAnalysisExtractor() {
    }

    public SelectAnalysis extractPerfMeasureFrom(SqlExecutions sqlExecutions) {
        int selectNumber = sqlExecutions.retrieveQueryNumberOfType(QueryType.SELECT);
        boolean sameSelectTypesWithDifferentParamValues = false;
        int sameSelectsNumber = 0;
        SqlSelects sqlSelects = new SqlSelects();
        for (SqlExecution sqlExecution : sqlExecutions) {
            for (QueryInfo query : sqlExecution.getQueries()) {
                if (!this.isSelectType(query)) continue;
                if (!sameSelectTypesWithDifferentParamValues && sqlSelects.sameSqlQueryWithDifferentParams(query)) {
                    sameSelectTypesWithDifferentParamValues = true;
                }
                if (sqlSelects.exactlySameSqlQueryExists(query)) {
                    if (sameSelectsNumber == 0) {
                        sameSelectsNumber = 1;
                    }
                    ++sameSelectsNumber;
                }
                sqlSelects.add(query);
            }
        }
        return new SelectAnalysis(selectNumber, sameSelectsNumber, sameSelectTypesWithDifferentParamValues);
    }

    private boolean isSelectType(QueryInfo query) {
        QueryType queryType = QueryTypeRetriever.INSTANCE.typeOf(query);
        return QueryType.SELECT.equals((Object)queryType);
    }

    private static class SqlSelects {
        private final Map<String, ParamsCalls> callsParamsByQuery = new HashMap<String, ParamsCalls>();

        private SqlSelects() {
        }

        void add(QueryInfo query) {
            String queryAsString = query.getQuery();
            ParamsCalls paramsCalls = this.callsParamsByQuery.get(queryAsString);
            if (paramsCalls == null) {
                paramsCalls = new ParamsCalls();
            }
            List<Object> paramsList = QueryParamsExtractor.INSTANCE.getParamsOf(query);
            paramsCalls.addParams(paramsList);
            this.callsParamsByQuery.put(queryAsString, paramsCalls);
        }

        boolean sameSqlQueryWithDifferentParams(QueryInfo query) {
            String queryAsString = query.getQuery();
            ParamsCalls paramsCalls = this.callsParamsByQuery.get(queryAsString);
            if (paramsCalls == null) {
                return false;
            }
            List<Object> paramsList = QueryParamsExtractor.INSTANCE.getParamsOf(query);
            return !paramsCalls.alreadySameParamsCalled(paramsList);
        }

        boolean exactlySameSqlQueryExists(QueryInfo query) {
            String queryAsString = query.getQuery();
            ParamsCalls paramsCalls = this.callsParamsByQuery.get(queryAsString);
            if (paramsCalls == null) {
                return false;
            }
            List<Object> paramsList = QueryParamsExtractor.INSTANCE.getParamsOf(query);
            return paramsCalls.alreadySameParamsCalled(paramsList);
        }

        private static class ParamsCalls {
            private final List<List<Object>> paramsCalls = new ArrayList<List<Object>>();

            private ParamsCalls() {
            }

            boolean alreadySameParamsCalled(List<Object> params) {
                return this.paramsCalls.contains(params);
            }

            void addParams(List<Object> params) {
                this.paramsCalls.add(params);
            }
        }
    }
}

