/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.select;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.annotation.ExpectSelect;
import org.quickperf.sql.select.analysis.SelectAnalysis;
import org.quickperf.unit.Count;

public class SelectNumberPerfIssueVerifier
implements VerifiablePerformanceIssue<ExpectSelect, SelectAnalysis> {
    public static final SelectNumberPerfIssueVerifier INSTANCE = new SelectNumberPerfIssueVerifier();

    private SelectNumberPerfIssueVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectSelect annotation, SelectAnalysis selectAnalysis) {
        Count expectedSelectNumber = new Count(Integer.valueOf(annotation.value()));
        Count executedSelectNumber = selectAnalysis.getSelectNumber();
        if (!executedSelectNumber.isEqualTo((PerfMeasure)expectedSelectNumber)) {
            return this.buildPerfIssue(executedSelectNumber, expectedSelectNumber, selectAnalysis);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(Count executedSelectNumber, Count expectedSelectNumber, SelectAnalysis selectAnalysis) {
        String description = this.buildBaseDescription(executedSelectNumber, expectedSelectNumber);
        if (executedSelectNumber.isGreaterThan((PerfMeasure)Count.ONE) && executedSelectNumber.isGreaterThan((PerfMeasure)expectedSelectNumber) && !selectAnalysis.hasOnlySameSelects()) {
            description = description + SelectAnalysis.getSuggestionToFIxNPlusOneSelect();
        }
        return new PerfIssue(description);
    }

    private String buildBaseDescription(Count measuredCount, Count expectedCount) {
        boolean severalExpectedStatements = expectedCount.getValue() > 1L;
        boolean severalExecutedStatements = measuredCount.getValue() > 1L;
        return "You may think that <" + expectedCount.getValue() + "> select statement" + (severalExpectedStatements ? "s were" : " was") + " sent to the database" + System.lineSeparator() + "       But there " + (severalExecutedStatements ? "are" : "is") + " in fact <" + measuredCount.getValue() + ">...";
    }
}

