/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.select;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.SqlStatementPerfIssueBuilder;
import org.quickperf.sql.annotation.ExpectMaxSelect;
import org.quickperf.sql.select.analysis.SelectAnalysis;
import org.quickperf.unit.Count;

public class MaxOfSelectsPerfIssueVerifier
implements VerifiablePerformanceIssue<ExpectMaxSelect, SelectAnalysis> {
    public static final MaxOfSelectsPerfIssueVerifier INSTANCE = new MaxOfSelectsPerfIssueVerifier();

    private MaxOfSelectsPerfIssueVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxSelect annotation, SelectAnalysis selectAnalysis) {
        Count maxExpectedSelect = new Count(Integer.valueOf(annotation.value()));
        Count executedSelectNumber = selectAnalysis.getSelectNumber();
        if (executedSelectNumber.isGreaterThan((PerfMeasure)maxExpectedSelect)) {
            return this.buildPerfIssue(executedSelectNumber, maxExpectedSelect, selectAnalysis);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(Count measuredCount, Count expectedCount, SelectAnalysis selectAnalysis) {
        String description = SqlStatementPerfIssueBuilder.aSqlPerfIssue().buildMaxOfStatementsDesc(measuredCount, expectedCount, "select");
        if (measuredCount.isGreaterThan((PerfMeasure)Count.ONE) && !selectAnalysis.hasOnlySameSelects()) {
            description = description + SelectAnalysis.getSuggestionToFIxNPlusOneSelect();
        }
        return new PerfIssue(description);
    }
}

