/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.repository;

import java.io.File;
import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import org.quickperf.WorkingFolder;
import org.quickperf.repository.ObjectFileRepository;
import org.quickperf.sql.SqlExecutions;
import org.quickperf.sql.repository.SqlMemoryRepository;
import org.quickperf.sql.repository.SqlRepository;

class SqlFileRepository
implements SqlRepository {
    private static final String SQL_FILE_NAME = "sql.ser";
    private final SqlMemoryRepository sqlMemoryRepository = new SqlMemoryRepository();
    private boolean flushed;
    private final ObjectFileRepository objectFileRepository = ObjectFileRepository.getInstance();

    SqlFileRepository() {
    }

    @Override
    public void addQueryExecution(ExecutionInfo execInfo, List<QueryInfo> queries) {
        this.sqlMemoryRepository.addQueryExecution(execInfo, queries);
    }

    @Override
    public void flush(WorkingFolder workingFolder) {
        if (!this.flushed) {
            SqlExecutions executedQueries = this.sqlMemoryRepository.findExecutedQueries(workingFolder);
            if (!executedQueries.isEmpty()) {
                this.objectFileRepository.save(workingFolder, SQL_FILE_NAME, (Object)executedQueries);
            }
            this.flushed = true;
        }
    }

    @Override
    public SqlExecutions findExecutedQueries(WorkingFolder workingFolder) {
        SqlExecutions sqlExecutionsFromMemory = this.sqlMemoryRepository.findExecutedQueries(workingFolder);
        if (sqlExecutionsFromMemory.isEmpty()) {
            SqlExecutions sqlExecutionsFromFile = this.retrieveExecutedQueriesFromFile(workingFolder);
            this.sqlMemoryRepository.saveSqlExecutions(sqlExecutionsFromFile);
            return sqlExecutionsFromFile;
        }
        return sqlExecutionsFromMemory;
    }

    private SqlExecutions retrieveExecutedQueriesFromFile(WorkingFolder workingFolder) {
        if (!this.sqlFileExists(workingFolder)) {
            return SqlExecutions.NONE;
        }
        Object sqlExecutionsAsObject = this.objectFileRepository.find(workingFolder.getPath(), SQL_FILE_NAME);
        if (sqlExecutionsAsObject == null) {
            return SqlExecutions.NONE;
        }
        return (SqlExecutions)sqlExecutionsAsObject;
    }

    private boolean sqlFileExists(WorkingFolder workingFolder) {
        String workingFolderPath = workingFolder.getPath();
        File sqlFile = new File(workingFolderPath + File.separator + SQL_FILE_NAME);
        return sqlFile.exists();
    }
}

