/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.like;

import net.ttddyy.dsproxy.QueryInfo;
import org.quickperf.ExtractablePerformanceMeasure;
import org.quickperf.measure.BooleanMeasure;
import org.quickperf.sql.SqlExecution;
import org.quickperf.sql.SqlExecutions;

public class ContainsLikeWithLeadingWildcardExtractor
implements ExtractablePerformanceMeasure<SqlExecutions, BooleanMeasure> {
    public static final ContainsLikeWithLeadingWildcardExtractor INSTANCE = new ContainsLikeWithLeadingWildcardExtractor();

    private ContainsLikeWithLeadingWildcardExtractor() {
    }

    public BooleanMeasure extractPerfMeasureFrom(SqlExecutions sqlExecutions) {
        for (SqlExecution sqlExecution : sqlExecutions) {
            for (QueryInfo query : sqlExecution.getQueries()) {
                if (!this.searchLikeWithLeadingWildcardOn(query)) continue;
                return BooleanMeasure.TRUE;
            }
        }
        return BooleanMeasure.FALSE;
    }

    private boolean searchLikeWithLeadingWildcardOn(QueryInfo queryInfo) {
        String query = queryInfo.getQuery();
        String queryInLowerCase = query.toLowerCase();
        String queryInLowerCaseWithoutWhiteSpaces = queryInLowerCase.replace(" ", "");
        return queryInLowerCaseWithoutWhiteSpaces.contains("like'%") || queryInLowerCaseWithoutWhiteSpaces.contains("like'_");
    }
}

