/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.framework.quickperf;

import org.quickperf.sql.framework.ClassPath;
import org.quickperf.sql.framework.QuickPerfSuggestion;
import org.quickperf.sql.framework.quickperf.DefaultConfig;
import org.quickperf.sql.framework.quickperf.MicronautDataConfig;
import org.quickperf.sql.framework.quickperf.MicronautHibernateJpaConfig;
import org.quickperf.sql.framework.quickperf.QuarkusDataSourceConfig;
import org.quickperf.sql.framework.quickperf.SpringDataSourceConfig;

public class DataSourceFrameworkConfigFactory {
    private DataSourceFrameworkConfigFactory() {
    }

    public static QuickPerfSuggestion makeFrom(ClassPath classPath) {
        if (classPath.containsSpringCore()) {
            return new SpringDataSourceConfig(classPath);
        }
        if (classPath.containsQuarkusCore()) {
            return new QuarkusDataSourceConfig();
        }
        if (classPath.containsMicronautData()) {
            return new MicronautDataConfig();
        }
        if (classPath.containsMicronautHibernateJpa()) {
            return new MicronautHibernateJpaConfig();
        }
        return new DefaultConfig();
    }
}

