/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.formatter;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.quickperf.QuickPerfUserConfigClasses;
import org.quickperf.SystemProperties;
import org.quickperf.sql.SqlFormatter;
import org.quickperf.sql.config.SpecifiableSqlFormatter;

class SqlFormatterDefinedByUserRetriever {
    static final SqlFormatterDefinedByUserRetriever INSTANCE = new SqlFormatterDefinedByUserRetriever();

    private SqlFormatterDefinedByUserRetriever() {
    }

    SqlFormatter retrieveSqlFormatterDefinedByUser() {
        SpecifiableSqlFormatter sqlFormatterImpl = null;
        try {
            sqlFormatterImpl = INSTANCE.findClassImplementingSpecifiableSqlFormatter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sqlFormatterImpl != null) {
            return sqlFormatterImpl.specifySqlFormatter();
        }
        return SqlFormatter.NONE;
    }

    private SpecifiableSqlFormatter findClassImplementingSpecifiableSqlFormatter() throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        Class[] classes;
        QuickPerfUserConfigClasses quickPerfUserConfigClasses = QuickPerfUserConfigClasses.INSTANCE;
        for (Class clazz : classes = quickPerfUserConfigClasses.findClasses()) {
            Class<?>[] interfaces;
            for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
                if (!this.isSpecifiableSqlFormatterImpl(interfaceClass)) continue;
                if (!((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
                    System.out.println("A class specifying a SQL basicFormatter has been found: " + clazz.getCanonicalName());
                }
                try {
                    return this.instantiateSpecifiableSqlFormatter(clazz);
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private SpecifiableSqlFormatter instantiateSpecifiableSqlFormatter(Class clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (SpecifiableSqlFormatter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private boolean isSpecifiableSqlFormatterImpl(Class interfaceClass) {
        return interfaceClass.getCanonicalName().equals(SpecifiableSqlFormatter.class.getCanonicalName());
    }
}

