/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.execution;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.annotation.ExpectMaxJdbcQueryExecution;
import org.quickperf.sql.execution.SqlAnalysis;
import org.quickperf.sql.select.analysis.SelectAnalysis;
import org.quickperf.unit.Count;

public class MaxJdbcQueryExecutionVerifier
implements VerifiablePerformanceIssue<ExpectMaxJdbcQueryExecution, SqlAnalysis> {
    public static final MaxJdbcQueryExecutionVerifier INSTANCE = new MaxJdbcQueryExecutionVerifier();

    private MaxJdbcQueryExecutionVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxJdbcQueryExecution annotation, SqlAnalysis sqlAnalysis) {
        Count expectedExpectJdbcQueryExecution = new Count(Integer.valueOf(annotation.value()));
        Count jdbcQueryExecution = sqlAnalysis.getJdbcQueryExecutionNumber();
        if (jdbcQueryExecution.isGreaterThan((PerfMeasure)expectedExpectJdbcQueryExecution)) {
            String description = this.buildBaseDescription(jdbcQueryExecution, expectedExpectJdbcQueryExecution) + this.buildPotentialSuggestionToFix(sqlAnalysis, jdbcQueryExecution, expectedExpectJdbcQueryExecution);
            return new PerfIssue(description);
        }
        return PerfIssue.NONE;
    }

    private String buildBaseDescription(Count executionNumber, Count expectedExecutionNumber) {
        boolean severalExpectedExecutions = expectedExecutionNumber.getValue() > 1L;
        boolean severalExecutions = executionNumber.getValue() > 1L;
        return "You may think that there " + (severalExpectedExecutions ? "were" : "was") + " at most <" + expectedExecutionNumber.getValue() + "> JDBC query execution" + (severalExpectedExecutions ? "s" : "") + " (execute, executeQuery, executeBatch, ...)" + System.lineSeparator() + "       But there " + (severalExecutions ? "are" : "is") + " <" + executionNumber.getValue() + ">...";
    }

    private String buildPotentialSuggestionToFix(SqlAnalysis sqlAnalysis, Count executionNumber, Count expectedExecutionNumber) {
        SelectAnalysis selectAnalysis = sqlAnalysis.getSelectAnalysis();
        SelectAnalysis.SameSelectTypesWithDifferentParamValues sameSelectTypesWithDifferentParamValues = selectAnalysis.getSameSelectTypesWithDifferentParamValues();
        if (executionNumber.isGreaterThan((PerfMeasure)expectedExecutionNumber) && sameSelectTypesWithDifferentParamValues.evaluate()) {
            return sameSelectTypesWithDifferentParamValues.getSuggestionToFixIt();
        }
        return "";
    }
}

