/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.execution;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.annotation.ExpectJdbcQueryExecution;
import org.quickperf.sql.execution.SqlAnalysis;
import org.quickperf.sql.select.analysis.SelectAnalysis;
import org.quickperf.unit.Count;

public class JdbcQueryExecutionVerifier
implements VerifiablePerformanceIssue<ExpectJdbcQueryExecution, SqlAnalysis> {
    public static final JdbcQueryExecutionVerifier INSTANCE = new JdbcQueryExecutionVerifier();

    private JdbcQueryExecutionVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectJdbcQueryExecution annotation, SqlAnalysis sqlAnalysis) {
        Count expectedExecutionNumber = new Count(Integer.valueOf(annotation.value()));
        Count executionNumber = sqlAnalysis.getJdbcQueryExecutionNumber();
        if (!executionNumber.isEqualTo((PerfMeasure)expectedExecutionNumber)) {
            String description = this.buildBaseDescription(executionNumber, expectedExecutionNumber) + this.buildPotentialSuggestionToFix(sqlAnalysis, executionNumber, expectedExecutionNumber);
            return new PerfIssue(description);
        }
        return PerfIssue.NONE;
    }

    private String buildBaseDescription(Count executionNumber, Count expectedExecutionNumber) {
        boolean severalExpectedExecutions = expectedExecutionNumber.getValue() > 1L;
        boolean severalExecutions = executionNumber.getValue() > 1L;
        return "You may think that there " + (severalExpectedExecutions ? "were" : "was") + " <" + expectedExecutionNumber.getValue() + "> JDBC query execution" + (severalExpectedExecutions ? "s" : "") + " (execute, executeQuery, executeBatch, ...)" + System.lineSeparator() + "       But there " + (severalExecutions ? "are" : "is") + " <" + executionNumber.getValue() + ">...";
    }

    private String buildPotentialSuggestionToFix(SqlAnalysis sqlAnalysis, Count executionNumber, Count expectedExecutionNumber) {
        SelectAnalysis selectAnalysis = sqlAnalysis.getSelectAnalysis();
        SelectAnalysis.SameSelectTypesWithDifferentParamValues sameSelectTypesWithDifferentParamValues = selectAnalysis.getSameSelectTypesWithDifferentParamValues();
        if (executionNumber.isGreaterThan((PerfMeasure)expectedExecutionNumber) && sameSelectTypesWithDifferentParamValues.evaluate()) {
            return sameSelectTypesWithDifferentParamValues.getSuggestionToFixIt();
        }
        return "";
    }
}

