/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.batch;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.sql.annotation.ExpectJdbcBatching;
import org.quickperf.sql.batch.SqlBatchSizes;
import org.quickperf.sql.framework.JdbcSuggestion;

public class SqlStatementBatchVerifier
implements VerifiablePerformanceIssue<ExpectJdbcBatching, SqlBatchSizes> {
    public static final SqlStatementBatchVerifier INSTANCE = new SqlStatementBatchVerifier();

    private SqlStatementBatchVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectJdbcBatching annotation, SqlBatchSizes measuredSqlBatchSizes) {
        boolean userHasGivenBatchSize;
        int expectedBatchSize = annotation.batchSize();
        int[] measuredBatchSizesAsArray = measuredSqlBatchSizes.getValue();
        boolean bl = userHasGivenBatchSize = expectedBatchSize != -1;
        if (userHasGivenBatchSize) {
            return this.verifyBatchSize(expectedBatchSize, measuredBatchSizesAsArray);
        }
        return this.verifyThatInsertUpdateDeleteExecutionAreBatched(measuredBatchSizesAsArray);
    }

    private PerfIssue verifyThatInsertUpdateDeleteExecutionAreBatched(int[] measuredBatchSizesAsArray) {
        for (int measuredBatchSize : measuredBatchSizesAsArray) {
            if (measuredBatchSize != 0) continue;
            String description = "JDBC batching is disabled." + System.lineSeparator() + JdbcSuggestion.BATCHING.getMessage() + System.lineSeparator() + "";
            return new PerfIssue(description);
        }
        return PerfIssue.NONE;
    }

    private int findNumberOfBatchSizeToCheck(int[] measuredBatchSizesAsArray) {
        if (measuredBatchSizesAsArray.length == 1) {
            return 1;
        }
        return measuredBatchSizesAsArray.length - 1;
    }

    private PerfIssue verifyBatchSize(int expectedBatchSize, int[] measuredBatchSizesAsArray) {
        int numberOfBatchSizeToCheck = this.findNumberOfBatchSizeToCheck(measuredBatchSizesAsArray);
        for (int i = 0; i < numberOfBatchSizeToCheck; ++i) {
            int measuredBatchSize = measuredBatchSizesAsArray[i];
            if (measuredBatchSize == expectedBatchSize) continue;
            return this.buildNotRespectedBatchSizePerfIssue(expectedBatchSize, measuredBatchSize);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildNotRespectedBatchSizePerfIssue(int expectedBatchSize, int measuredBatchSize) {
        String description = "Expected batch size <" + expectedBatchSize + "> but is <" + measuredBatchSize + ">.";
        return new PerfIssue(description);
    }
}

