/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.batch;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.QueryType;
import org.quickperf.TestExecutionContext;
import org.quickperf.WorkingFolder;
import org.quickperf.repository.ObjectFileRepository;
import org.quickperf.sql.QueryTypeRetriever;
import org.quickperf.sql.SqlRecorder;
import org.quickperf.sql.SqlRecorderRegistry;
import org.quickperf.sql.batch.SqlBatchSizes;

public class SqlStatementBatchRecorder
implements SqlRecorder<SqlBatchSizes> {
    private static final String BATCH_FILE_NAME = "ExpectJdbcBatching.ser";
    private boolean previousStatementsAreBatched = true;
    private int[] differentBatchSizes = new int[0];

    public void startRecording(TestExecutionContext testExecutionContext) {
        SqlRecorderRegistry.INSTANCE.register(this);
    }

    public void stopRecording(TestExecutionContext testExecutionContext) {
        SqlRecorderRegistry.unregister(this);
        if (testExecutionContext.testExecutionUsesTwoJVMs()) {
            WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
            this.saveCharacteristicsOfBatchExecutions(this.differentBatchSizes, workingFolder);
        }
    }

    private void saveCharacteristicsOfBatchExecutions(int[] batchExecutions, WorkingFolder workingFolder) {
        ObjectFileRepository objectFileRepository = ObjectFileRepository.INSTANCE;
        objectFileRepository.save(workingFolder, BATCH_FILE_NAME, (Object)new SqlBatchSizes(batchExecutions));
    }

    public SqlBatchSizes findRecord(TestExecutionContext testExecutionContext) {
        if (testExecutionContext.testExecutionUsesTwoJVMs()) {
            ObjectFileRepository objectFileRepository = ObjectFileRepository.INSTANCE;
            WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
            return (SqlBatchSizes)objectFileRepository.find(workingFolder.getPath(), BATCH_FILE_NAME);
        }
        return new SqlBatchSizes(this.differentBatchSizes);
    }

    @Override
    public void addQueryExecution(ExecutionInfo execInfo, List<QueryInfo> queries, int listenerIdentifier) {
        for (QueryInfo query : queries) {
            if (!this.previousStatementsAreBatched || !this.isRequestTypeInsertOrUpdateOrDeleteType(query)) continue;
            int batchSize = execInfo.getBatchSize();
            if (this.isNewBatchSize(batchSize)) {
                this.differentBatchSizes = this.createTableWithNewBatchSize(batchSize);
            }
            this.previousStatementsAreBatched = execInfo.isBatch();
        }
    }

    private int[] createTableWithNewBatchSize(int batchSize) {
        int newTableLength = this.differentBatchSizes.length + 1;
        int[] newTable = new int[newTableLength];
        System.arraycopy(this.differentBatchSizes, 0, newTable, 0, this.differentBatchSizes.length);
        newTable[newTableLength - 1] = batchSize;
        return newTable;
    }

    private boolean isNewBatchSize(int batchSize) {
        for (int currentBatchSize : this.differentBatchSizes) {
            if (batchSize != currentBatchSize) continue;
            return false;
        }
        return true;
    }

    private boolean isRequestTypeInsertOrUpdateOrDeleteType(QueryInfo query) {
        QueryTypeRetriever typeRetriever = QueryTypeRetriever.INSTANCE;
        QueryType queryType = typeRetriever.typeOf(query);
        return queryType.equals((Object)QueryType.INSERT) || queryType.equals((Object)QueryType.UPDATE) || queryType.equals((Object)QueryType.DELETE);
    }

    public void cleanResources() {
    }
}

