/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql;

import java.util.ArrayList;
import java.util.Collection;
import org.quickperf.SystemProperties;
import org.quickperf.sql.SqlRecorder;

public class SqlRecorderRegistry {
    public static final SqlRecorderRegistry INSTANCE = new SqlRecorderRegistry();
    private final Collection<SqlRecorder> sqlRecordersOfTestJvm = new ArrayList<SqlRecorder>();
    private static final InheritableThreadLocal<Collection<SqlRecorder>> SQL_RECORDERS_WHEN_ONE_JVM = new InheritableThreadLocal<Collection<SqlRecorder>>(){

        @Override
        protected Collection<SqlRecorder> initialValue() {
            return new ArrayList<SqlRecorder>();
        }
    };

    private SqlRecorderRegistry() {
    }

    public void register(SqlRecorder sqlRecorder) {
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            this.sqlRecordersOfTestJvm.add(sqlRecorder);
        } else {
            Collection sqlRecorders = (Collection)SQL_RECORDERS_WHEN_ONE_JVM.get();
            sqlRecorders.add(sqlRecorder);
        }
    }

    public static void unregister(SqlRecorder sqlRecorder) {
        if (!((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            Collection sqlRecorders = (Collection)SQL_RECORDERS_WHEN_ONE_JVM.get();
            sqlRecorders.remove(sqlRecorder);
        }
    }

    public Collection<SqlRecorder> getSqlRecorders() {
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            return this.sqlRecordersOfTestJvm;
        }
        return (Collection)SQL_RECORDERS_WHEN_ONE_JVM.get();
    }
}

