/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.QueryType;
import net.ttddyy.dsproxy.StatementType;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;
import org.quickperf.sql.QueryTypeRetriever;
import org.quickperf.sql.SqlQueryPredicate;
import org.quickperf.sql.formatter.QuickPerfSqlFormatter;

public class SqlExecution
implements Externalizable {
    private ExecutionInfo executionInfo;
    private List<QueryInfo> queries;
    private long columnCount;

    public SqlExecution() {
    }

    public SqlExecution(ExecutionInfo executionInfo, List<QueryInfo> queries) {
        this.executionInfo = executionInfo;
        this.queries = queries;
        if (this.atLeastOneSelect(queries)) {
            this.columnCount = this.retrieveNumberOfReturnedColumns(executionInfo);
        }
    }

    private boolean atLeastOneSelect(List<QueryInfo> queries) {
        QueryTypeRetriever queryTypeRetriever = QueryTypeRetriever.INSTANCE;
        for (QueryInfo query : queries) {
            QueryType queryType = queryTypeRetriever.typeOf(query);
            if (queryType != QueryType.SELECT) continue;
            return true;
        }
        return false;
    }

    private long retrieveNumberOfReturnedColumns(ExecutionInfo executionInfo) {
        if (this.dbExceptionHappened(executionInfo) || this.executeMethodOnStatement(executionInfo)) {
            return 0L;
        }
        ResultSet resultSet = (ResultSet)executionInfo.getResult();
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            return metaData.getColumnCount();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private boolean dbExceptionHappened(ExecutionInfo executionInfo) {
        return executionInfo.getResult() == null;
    }

    private boolean executeMethodOnStatement(ExecutionInfo executionInfo) {
        return !(executionInfo.getResult() instanceof ResultSet);
    }

    public boolean hasQueryFollowing(SqlQueryPredicate sqlQueryPredicate) {
        if (this.queries == null) {
            return false;
        }
        for (QueryInfo queryInfo : this.queries) {
            if (!sqlQueryPredicate.test(queryInfo.getQuery())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExecutionInfo(out);
        out.writeLong(this.columnCount);
        this.writeQueries(out);
    }

    private void writeExecutionInfo(ObjectOutput out) throws IOException {
        out.writeUTF(this.executionInfo.getDataSourceName());
        out.writeUTF(this.executionInfo.getConnectionId());
        out.writeUTF(this.executionInfo.getStatementType().name());
        out.writeBoolean(this.executionInfo.isBatch());
        out.writeInt(this.executionInfo.getBatchSize());
    }

    private void writeQueries(ObjectOutput out) throws IOException {
        int numberOfQueries = this.queries.size();
        out.writeInt(numberOfQueries);
        for (QueryInfo query : this.queries) {
            this.writeQuery(out, query);
        }
    }

    private void writeQuery(ObjectOutput out, QueryInfo query) throws IOException {
        String queryAsString = query.getQuery();
        out.writeUTF(queryAsString);
        List parametersList = query.getParametersList();
        int numberOfParametersList = parametersList.size();
        out.writeInt(numberOfParametersList);
        for (List parameters : parametersList) {
            int numberOfParams = parameters.size();
            out.writeInt(numberOfParams);
            for (ParameterSetOperation parameter : parameters) {
                this.writeParameter(out, parameter);
            }
        }
    }

    private void writeParameter(ObjectOutput out, ParameterSetOperation parameter) throws IOException {
        Method method = parameter.getMethod();
        this.writeMethod(out, method);
        Object[] args = parameter.getArgs();
        this.writeArgs(out, args);
    }

    private void writeMethod(ObjectOutput out, Method method) throws IOException {
        out.writeObject(method.getDeclaringClass());
        out.writeUTF(method.getName());
        out.writeObject(method.getParameterTypes());
    }

    private void writeArgs(ObjectOutput out, Object[] args) throws IOException {
        int numberOfArgs = args.length;
        out.writeInt(numberOfArgs);
        for (Object arg : args) {
            out.writeObject(arg);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.executionInfo = this.readExecutionInfo(in);
        this.columnCount = in.readLong();
        this.queries = this.readQueries(in);
    }

    private ExecutionInfo readExecutionInfo(ObjectInput in) throws IOException {
        ExecutionInfo executionInfo = new ExecutionInfo();
        executionInfo.setDataSourceName(in.readUTF());
        executionInfo.setConnectionId(in.readUTF());
        executionInfo.setStatementType(StatementType.valueOf((String)in.readUTF()));
        executionInfo.setBatch(in.readBoolean());
        executionInfo.setBatchSize(in.readInt());
        return executionInfo;
    }

    private List<QueryInfo> readQueries(ObjectInput in) throws IOException, ClassNotFoundException {
        int numberOfQueries = in.readInt();
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>(numberOfQueries);
        for (int i = 0; i < numberOfQueries; ++i) {
            QueryInfo query = this.readQuery(in);
            queries.add(query);
        }
        return queries;
    }

    private QueryInfo readQuery(ObjectInput in) throws IOException, ClassNotFoundException {
        QueryInfo query = new QueryInfo();
        query.setQuery(in.readUTF());
        int numberOfParametersList = in.readInt();
        ArrayList parametersList = new ArrayList(numberOfParametersList);
        for (int j = 0; j < numberOfParametersList; ++j) {
            int numberOfParams = in.readInt();
            ArrayList<ParameterSetOperation> parameters = new ArrayList<ParameterSetOperation>(numberOfParams);
            for (int k = 0; k < numberOfParams; ++k) {
                ParameterSetOperation parameterSetOperation = new ParameterSetOperation();
                Method method = this.readMethod(in);
                parameterSetOperation.setMethod(method);
                Object[] args = this.readArgs(in);
                parameterSetOperation.setArgs(args);
                parameters.add(parameterSetOperation);
            }
            parametersList.add(parameters);
        }
        query.setParametersList(parametersList);
        return query;
    }

    private Method readMethod(ObjectInput in) throws ClassNotFoundException, IOException {
        Method method;
        Class declaringClass = (Class)in.readObject();
        String methodName = in.readUTF();
        Class[] parameterTypes = (Class[])in.readObject();
        try {
            method = declaringClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return method;
    }

    private Object[] readArgs(ObjectInput in) throws IOException, ClassNotFoundException {
        int numberOfArgs = in.readInt();
        Object[] args = new Object[numberOfArgs];
        for (int l = 0; l < numberOfArgs; ++l) {
            Object object;
            args[l] = object = in.readObject();
        }
        return args;
    }

    public List<QueryInfo> getQueries() {
        return this.queries;
    }

    public long getColumnCount() {
        return this.columnCount;
    }

    public long getElapsedTime() {
        return this.executionInfo.getElapsedTime();
    }

    public boolean withStatement() {
        StatementType statementType = this.executionInfo.getStatementType();
        return StatementType.STATEMENT.equals((Object)statementType);
    }

    public String toString() {
        return QuickPerfSqlFormatter.INSTANCE.format(this.executionInfo, this.queries);
    }
}

