/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import org.quickperf.TestExecutionContext;
import org.quickperf.WorkingFolder;
import org.quickperf.sql.DataSourceProxyVerifier;
import org.quickperf.sql.SqlExecutions;
import org.quickperf.sql.SqlRecorder;
import org.quickperf.sql.SqlRecorderRegistry;
import org.quickperf.sql.repository.SqlRepository;
import org.quickperf.sql.repository.SqlRepositoryFactory;

public class PersistenceSqlRecorder
implements SqlRecorder<SqlExecutions> {
    private final DataSourceProxyVerifier datasourceProxyVerifier = new DataSourceProxyVerifier();
    private SqlRepository sqlRepository;

    public void startRecording(TestExecutionContext testExecutionContext) {
        SqlRecorderRegistry.INSTANCE.register(this);
        this.sqlRepository = SqlRepositoryFactory.getSqlRepository(testExecutionContext);
    }

    @Override
    public void addQueryExecution(ExecutionInfo execInfo, List<QueryInfo> queries, int listenerIdentifier) {
        this.datasourceProxyVerifier.addListenerIdentifier(listenerIdentifier);
        this.sqlRepository.addQueryExecution(execInfo, queries);
    }

    public void stopRecording(TestExecutionContext testExecutionContext) {
        SqlRecorderRegistry.unregister(this);
        WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
        this.sqlRepository.flush(workingFolder);
        if (this.datasourceProxyVerifier.hasQuickPerfBuiltSeveralDataSourceProxies()) {
            System.out.println();
            System.err.println("[WARNING] QuickPerf has built several datasource proxies");
        }
    }

    public SqlExecutions findRecord(TestExecutionContext testExecutionContext) {
        if (this.sqlRepository == null) {
            this.sqlRepository = SqlRepositoryFactory.getSqlRepository(testExecutionContext);
        }
        WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
        return this.sqlRepository.findExecutedQueries(workingFolder);
    }

    public void cleanResources() {
    }
}

