/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.rss;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.quickperf.measure.AbstractComparablePerfMeasure;

class ProcessStatus
extends AbstractComparablePerfMeasure<ProcessStatus>
implements Serializable {
    private static ProcessStatus record;
    private long rssInKb;
    private String pid;

    ProcessStatus() {
    }

    static void record() {
        String statusFile = "/proc/self/status";
        try {
            List status = FileUtils.readLines((File)new File(statusFile), (String)"UTF-8");
            ProcessStatus ps = new ProcessStatus();
            for (String line : status) {
                if (line.startsWith("VmRSS")) {
                    String rss = line.substring(6, line.length() - 2).trim();
                    ps.setRssInKb(Long.parseLong(rss));
                }
                if (!line.startsWith("Pid")) continue;
                String pid = line.substring(4).trim();
                ps.setPid(pid);
            }
            record = ps;
        }
        catch (IOException e) {
            System.out.println("[QUICK PERF] - ERROR - Unable to read the status file " + statusFile + " : status file are only available on Linux");
        }
    }

    static ProcessStatus getRecord() {
        return record;
    }

    static void reset() {
        record = null;
    }

    public long getRssInKb() {
        return this.rssInKb;
    }

    public void setRssInKb(long rssInKb) {
        this.rssInKb = rssInKb;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public int compareTo(ProcessStatus processStatus) {
        return 0;
    }

    public Object getValue() {
        return record;
    }

    public Object getUnit() {
        return "kb";
    }

    public String getComment() {
        return null;
    }
}

