/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.annotations;

import java.lang.annotation.Annotation;
import org.quickperf.jvm.allocation.AllocationUnit;
import org.quickperf.jvm.annotations.EnableGcLogging;
import org.quickperf.jvm.annotations.ExpectMaxHeapAllocation;
import org.quickperf.jvm.annotations.ExpectMaxRSS;
import org.quickperf.jvm.annotations.ExpectNoHeapAllocation;
import org.quickperf.jvm.annotations.HeapSize;
import org.quickperf.jvm.annotations.JvmOptions;
import org.quickperf.jvm.annotations.MeasureHeapAllocation;
import org.quickperf.jvm.annotations.MeasureRSS;
import org.quickperf.jvm.annotations.UseGC;
import org.quickperf.jvm.annotations.Xms;
import org.quickperf.jvm.annotations.Xmx;
import org.quickperf.jvm.gc.GC;
import org.quickperf.writer.DefaultWriterFactory;
import org.quickperf.writer.WriterFactory;

public class JvmAnnotationBuilder {
    private JvmAnnotationBuilder() {
    }

    public static HeapSize heapSize(final int value, final AllocationUnit unit) {
        return new HeapSize(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return HeapSize.class;
            }

            @Override
            public int value() {
                return value;
            }

            @Override
            public AllocationUnit unit() {
                return unit;
            }
        };
    }

    public static JvmOptions jvmOptions(final String value) {
        return new JvmOptions(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return JvmOptions.class;
            }

            @Override
            public String value() {
                return value;
            }
        };
    }

    public static UseGC useGC(final GC gc) {
        return new UseGC(){

            @Override
            public GC value() {
                return gc;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return UseGC.class;
            }
        };
    }

    public static EnableGcLogging enableGcLogging() {
        return new EnableGcLogging(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return EnableGcLogging.class;
            }
        };
    }

    public static ExpectMaxHeapAllocation expectMaxHeapAllocation(final double value, final AllocationUnit unit) {
        return new ExpectMaxHeapAllocation(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ExpectMaxHeapAllocation.class;
            }

            @Override
            public double value() {
                return value;
            }

            @Override
            public AllocationUnit unit() {
                return unit;
            }
        };
    }

    public static MeasureHeapAllocation measureHeapAllocation(final String format, final Class<? extends WriterFactory> writerFactoryClass) {
        return new MeasureHeapAllocation(){

            @Override
            public String format() {
                return format;
            }

            @Override
            public Class<? extends WriterFactory> writerFactory() {
                return writerFactoryClass;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return MeasureHeapAllocation.class;
            }
        };
    }

    public static MeasureHeapAllocation measureHeapAllocation() {
        return JvmAnnotationBuilder.measureHeapAllocation("[QUICK PERF] Measured heap allocation (test method thread): %s\n", DefaultWriterFactory.class);
    }

    public static MeasureHeapAllocation measureHeapAllocation(String format) {
        return JvmAnnotationBuilder.measureHeapAllocation(format, DefaultWriterFactory.class);
    }

    public static MeasureHeapAllocation measureHeapAllocation(Class<? extends WriterFactory> writerFactoryClass) {
        return JvmAnnotationBuilder.measureHeapAllocation("[QUICK PERF] Measured heap allocation (test method thread): %s\n", writerFactoryClass);
    }

    public static MeasureRSS measureRSS() {
        return new MeasureRSS(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return MeasureRSS.class;
            }
        };
    }

    public static ExpectMaxRSS expectMaxRSS(final double value, final AllocationUnit unit) {
        return new ExpectMaxRSS(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ExpectMaxRSS.class;
            }

            @Override
            public double value() {
                return value;
            }

            @Override
            public AllocationUnit unit() {
                return unit;
            }
        };
    }

    public static ExpectNoHeapAllocation expectNoHeapAllocation() {
        return new ExpectNoHeapAllocation(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ExpectNoHeapAllocation.class;
            }
        };
    }

    public static Xms xms(final int value, final AllocationUnit unit) {
        return new Xms(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Xms.class;
            }

            @Override
            public int value() {
                return value;
            }

            @Override
            public AllocationUnit unit() {
                return unit;
            }
        };
    }

    public static Xmx xmx(final int value, final AllocationUnit unit) {
        return new Xmx(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Xmx.class;
            }

            @Override
            public int value() {
                return value;
            }

            @Override
            public AllocationUnit unit() {
                return unit;
            }
        };
    }
}

