/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.allocation;

import java.io.PrintWriter;
import java.io.Writer;
import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.jvm.allocation.Allocation;
import org.quickperf.jvm.allocation.ByteAllocationMeasureFormatter;
import org.quickperf.jvm.annotations.MeasureHeapAllocation;
import org.quickperf.writer.DefaultWriterFactory;
import org.quickperf.writer.WriterFactory;

public class MeasureHeapAllocationPerfVerifier
implements VerifiablePerformanceIssue<MeasureHeapAllocation, Allocation> {
    public static final VerifiablePerformanceIssue INSTANCE = new MeasureHeapAllocationPerfVerifier();
    private final ByteAllocationMeasureFormatter byteAllocationMeasureFormatter = ByteAllocationMeasureFormatter.INSTANCE;

    private MeasureHeapAllocationPerfVerifier() {
    }

    public PerfIssue verifyPerfIssue(MeasureHeapAllocation annotation, Allocation measuredAllocation) {
        String allocationAsString = this.byteAllocationMeasureFormatter.formatAndAppendAllocationInBytes(measuredAllocation);
        Class<? extends WriterFactory> writerFactoryClass = annotation.writerFactory();
        try (PrintWriter pw = this.buildPrintWriterFrom(writerFactoryClass);){
            pw.printf(annotation.format(), allocationAsString);
        }
        return PerfIssue.NONE;
    }

    private PrintWriter buildPrintWriterFrom(Class<? extends WriterFactory> writerFactoryClass) {
        PrintWriter pw;
        try {
            WriterFactory writerFactory = writerFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Writer writer = writerFactory.buildWriter();
            pw = new PrintWriter(writer);
        }
        catch (Exception e) {
            System.out.printf("Unexpected exception while building the writer factory [%s]\n", writerFactoryClass.getName());
            e.printStackTrace(System.out);
            System.out.println("Messages will be sent to System.out");
            pw = DefaultWriterFactory.SystemOutPrintWriterInstance.INSTANCE.getSystemOutPrintWriter();
        }
        return pw;
    }
}

