/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.quickperf.jvm.annotations.JvmOptions;
import org.quickperf.testlauncher.JvmOption;

public class JvmOptionConverter {
    public static final JvmOptionConverter INSTANCE = new JvmOptionConverter();

    private JvmOptionConverter() {
    }

    public List<JvmOption> jvmOptionFrom(JvmOptions jvmOptions) {
        if (!this.jvmOptionsExist(jvmOptions)) {
            return Collections.emptyList();
        }
        String jvmOptionsAsAString = jvmOptions.value();
        List<String> jvmOptionsAsStrings = this.extractJvmOptionsAsStrings(jvmOptionsAsAString);
        return this.buildJvmOptionsAsObjects(jvmOptionsAsStrings);
    }

    private boolean jvmOptionsExist(JvmOptions jvmOptions) {
        String jvmOptionsAsAString = jvmOptions.value();
        return jvmOptions != null && !jvmOptionsAsAString.isEmpty();
    }

    private List<String> extractJvmOptionsAsStrings(String jvmOptionsAsAString) {
        String[] splittedJvmOptions;
        ArrayList<String> jvmOptionsAsStrings = new ArrayList<String>();
        for (String splittedJvmOption : splittedJvmOptions = jvmOptionsAsAString.split("\\s")) {
            if (splittedJvmOption.isEmpty()) continue;
            jvmOptionsAsStrings.add(splittedJvmOption);
        }
        return jvmOptionsAsStrings;
    }

    private List<JvmOption> buildJvmOptionsAsObjects(List<String> jvmOptionsAsStrings) {
        ArrayList<JvmOption> jvmOptionsAsObjects = new ArrayList<JvmOption>();
        for (String splittedJvmOption : jvmOptionsAsStrings) {
            JvmOption jvmOption = new JvmOption(splittedJvmOption);
            jvmOptionsAsObjects.add(jvmOption);
        }
        return jvmOptionsAsObjects;
    }
}

