/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.junit5;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.quickperf.SystemProperties;
import org.quickperf.TestExecutionContext;
import org.quickperf.config.library.QuickPerfConfigs;
import org.quickperf.config.library.QuickPerfConfigsLoader;
import org.quickperf.config.library.SetOfAnnotationConfigs;
import org.quickperf.issue.JvmOrTestIssue;
import org.quickperf.issue.PerfIssuesEvaluator;
import org.quickperf.issue.TestIssue;
import org.quickperf.junit5.QuickPerfJunit5Core;
import org.quickperf.perfrecording.PerformanceRecording;
import org.quickperf.reporter.QuickPerfReporter;
import org.quickperf.testlauncher.NewJvmTestLauncher;

public class QuickPerfTestExtension
implements BeforeEachCallback,
InvocationInterceptor {
    private final QuickPerfConfigs quickPerfConfigs = QuickPerfConfigsLoader.INSTANCE.loadQuickPerfConfigs();
    private final PerformanceRecording performanceRecording = PerformanceRecording.INSTANCE;
    private final PerfIssuesEvaluator perfIssuesEvaluator = PerfIssuesEvaluator.INSTANCE;
    private final QuickPerfReporter quickPerfReporter = QuickPerfReporter.INSTANCE;
    private TestExecutionContext testExecutionContext;

    public void beforeEach(ExtensionContext extensionContext) {
        int junit5AllocationOffset = 40;
        this.testExecutionContext = TestExecutionContext.buildFrom((QuickPerfConfigs)this.quickPerfConfigs, (Method)extensionContext.getRequiredTestMethod(), (int)junit5AllocationOffset);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (invocationContext.getTargetClass().equals(QuickPerfTestExtension.class)) {
            invocation.proceed();
        } else if (this.testExecutionContext.testExecutionUsesTwoJVMs() && !((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            invocation.skip();
        } else {
            invocation.proceed();
        }
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.testExecutionContext.testExecutionUsesTwoJVMs() && !((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            invocation.skip();
        } else {
            invocation.proceed();
        }
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.testExecutionContext.setRunnerAllocationOffset(0);
        if (this.testExecutionContext.isQuickPerfDisabled()) {
            invocation.proceed();
            return;
        }
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            this.executeTestMethodInNewJvmAndRecordPerformance(invocation, invocationContext);
            return;
        }
        JvmOrTestIssue jvmOrTestIssue = this.executeTestMethodAndRecordPerformance(invocation, invocationContext);
        this.processJvmOrTestIssue(jvmOrTestIssue);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.testExecutionContext.isQuickPerfDisabled()) {
            invocation.proceed();
            return;
        }
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            this.executeTestMethodInNewJvmAndRecordPerformance(invocation, invocationContext);
            return;
        }
        JvmOrTestIssue jvmOrTestIssue = this.executeTestMethodAndRecordPerformance(invocation, invocationContext);
        this.processJvmOrTestIssue(jvmOrTestIssue);
    }

    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        if (this.testExecutionContext.isQuickPerfDisabled()) {
            invocation.proceed();
            return;
        }
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            throw new RuntimeException("Cannot run a dynamic test on a forked JVM");
        }
        if (this.testExecutionContext.testExecutionUsesTwoJVMs()) {
            throw new RuntimeException("Cannot run a dynamic test on a forked JVM");
        }
        TestIssue testIssue = this.executeTestMethodAndRecordPerformanceInSameJvm(invocation);
        JvmOrTestIssue jvmOrTestIssue = JvmOrTestIssue.buildFrom((TestIssue)testIssue);
        this.processJvmOrTestIssue(jvmOrTestIssue);
    }

    private void processJvmOrTestIssue(JvmOrTestIssue jvmOrTestIssue) throws Throwable {
        SetOfAnnotationConfigs testAnnotationConfigs = this.quickPerfConfigs.getTestAnnotationConfigs();
        Collection groupOfPerfIssuesToFormat = this.perfIssuesEvaluator.evaluatePerfIssuesIfNoJvmIssue(testAnnotationConfigs, this.testExecutionContext, jvmOrTestIssue);
        this.testExecutionContext.cleanResources();
        this.quickPerfReporter.report(jvmOrTestIssue, groupOfPerfIssuesToFormat, this.testExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestMethodInNewJvmAndRecordPerformance(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext) throws IllegalAccessException, InvocationTargetException {
        Object[] args = invocationContext.getArguments().toArray();
        Object target = invocationContext.getTarget().orElse(null);
        Method method = this.makeAccessible((Method)invocationContext.getExecutable());
        invocation.skip();
        this.performanceRecording.start(this.testExecutionContext);
        try {
            method.invoke(target, args);
        }
        finally {
            this.performanceRecording.stop(this.testExecutionContext);
        }
    }

    private Method makeAccessible(Method executable) {
        if (!executable.isAccessible()) {
            executable.setAccessible(true);
        }
        return executable;
    }

    private JvmOrTestIssue executeTestMethodAndRecordPerformance(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext) {
        if (this.testExecutionContext.testExecutionUsesTwoJVMs()) {
            Method testMethod = (Method)invocationContext.getExecutable();
            JvmOrTestIssue jvmOrTestIssue = this.executeTestMethodInNewJwm(testMethod);
            this.tryToSkipInvocation(invocation);
            return jvmOrTestIssue;
        }
        TestIssue testIssue = this.executeTestMethodAndRecordPerformanceInSameJvm(invocation);
        return JvmOrTestIssue.buildFrom((TestIssue)testIssue);
    }

    private void tryToSkipInvocation(InvocationInterceptor.Invocation<Void> invocation) {
        try {
            invocation.skip();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.err.println("[QUICK PERF] A JUnit 5 version equal to or greater than 5.6.0 is required.");
            throw noSuchMethodError;
        }
    }

    private JvmOrTestIssue executeTestMethodInNewJwm(Method testMethod) {
        NewJvmTestLauncher newJvmTestLauncher = NewJvmTestLauncher.INSTANCE;
        return newJvmTestLauncher.executeTestMethodInNewJwm(testMethod, this.testExecutionContext, QuickPerfJunit5Core.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestIssue executeTestMethodAndRecordPerformanceInSameJvm(InvocationInterceptor.Invocation<Void> invocation) {
        this.performanceRecording.start(this.testExecutionContext);
        try {
            invocation.proceed();
            TestIssue testIssue = TestIssue.NONE;
            return testIssue;
        }
        catch (Throwable throwable) {
            TestIssue testIssue = TestIssue.buildFrom((Throwable)throwable);
            return testIssue;
        }
        finally {
            this.performanceRecording.stop(this.testExecutionContext);
        }
    }
}

