/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.dictgenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.quickfixj.dictgenerator.Component;
import org.quickfixj.dictgenerator.Enum;
import org.quickfixj.dictgenerator.Field;
import org.quickfixj.dictgenerator.Message;
import org.quickfixj.dictgenerator.MsgType;
import org.quickfixj.dictgenerator.Repository;

public class Generator {
    private final Repository repository;
    private final int major;
    private final int minor;

    public Generator(File repositoryDir, int major, int minor) throws Exception {
        System.out.println("Building Repository: " + repositoryDir.getAbsolutePath() + "...");
        this.repository = new Repository(repositoryDir);
        this.major = major;
        this.minor = minor;
    }

    public void generate() throws Exception {
        this.generateDictionary("session.xml", true, false);
        this.generateDictionary("application.xml", false, false);
        this.generateDictionary("merged.xml", false, true);
    }

    private void generateDictionary(String file, boolean admin, boolean merged) {
        Object standardTrailer;
        Component standardHeader;
        File dictionaryFile = new File(file);
        System.out.println("Creating file: " + dictionaryFile.getAbsolutePath());
        StringBuilder builder = new StringBuilder();
        if (!merged) {
            if (admin) {
                builder.append("<fix type=\"FIXT\" major=\"TODO\" minor=\"TODO\">\n");
            } else {
                builder.append("<fix major=\"").append(this.major).append("\" minor=\"").append(this.minor).append("\">\n");
            }
        } else {
            builder.append("<fix major=\"").append(this.major).append("\" minor=\"").append(this.minor).append("\">\n");
        }
        LinkedHashMap<String, MsgType> msgTypes = new LinkedHashMap<String, MsgType>();
        if (!merged) {
            if (admin) {
                msgTypes.putAll(this.repository.getSessionMsgTypes());
            } else {
                msgTypes.putAll(this.repository.getApplicationMsgTypes());
            }
        } else {
            msgTypes.putAll(this.repository.getSessionMsgTypes());
            msgTypes.putAll(this.repository.getApplicationMsgTypes());
        }
        Set<Integer> fieldsUsed = this.getAllFieldsUsed(msgTypes);
        Set<String> componentsUsed = this.getAllComponentsUsed(msgTypes);
        if (!merged) {
            if (admin) {
                builder.append("  <header>\n");
                standardHeader = this.repository.getStandardHeader((MsgType)msgTypes.values().iterator().next());
                this.addMsgContents(builder, standardHeader.getMsgContent(), "    ");
                builder.append("  </header>\n");
                builder.append("  <trailer>\n");
                standardTrailer = this.repository.getStandardTrailer((MsgType)msgTypes.values().iterator().next());
                this.addMsgContents(builder, ((Message)standardTrailer).getMsgContent(), "    ");
                builder.append("  </trailer>\n");
            } else {
                builder.append("  <header/>\n");
                builder.append("  <trailer/>\n");
            }
        } else {
            builder.append("  <header>\n");
            standardHeader = this.repository.getStandardHeader((MsgType)msgTypes.values().iterator().next());
            this.addMsgContents(builder, standardHeader.getMsgContent(), "    ");
            builder.append("  </header>\n");
            builder.append("  <trailer>\n");
            standardTrailer = this.repository.getStandardTrailer((MsgType)msgTypes.values().iterator().next());
            this.addMsgContents(builder, ((Message)standardTrailer).getMsgContent(), "    ");
            builder.append("  </trailer>\n");
        }
        if (!merged) {
            String msgcat = admin ? "admin" : "app";
            builder.append("  <messages>\n");
            for (MsgType msgType : msgTypes.values()) {
                if (msgType.getMsgType().equals("n")) {
                    builder.append("    <!-- \n");
                }
                builder.append("    <message name=\"").append(msgType.getName()).append("\" msgtype=\"").append(msgType.getMsgType()).append("\" msgcat=\"").append(msgcat).append("\">\n");
                this.addMsgContents(builder, msgType.getMsgContent(), "      ");
                builder.append("    </message>\n");
                if (!msgType.getMsgType().equals("n")) continue;
                builder.append("    --> \n");
            }
            builder.append("  </messages>\n");
        } else {
            builder.append("  <messages>\n");
            for (Object msgType : msgTypes.values()) {
                String string;
                String string2 = string = ((Message)msgType).getCategory().equals("Session") ? "admin" : "app";
                if (((MsgType)msgType).getMsgType().equals("n")) {
                    builder.append("    <!-- \n");
                }
                builder.append("    <message name=\"").append(((Message)msgType).getName()).append("\" msgtype=\"").append(((MsgType)msgType).getMsgType()).append("\" msgcat=\"").append(string).append("\">\n");
                this.addMsgContents(builder, ((Message)msgType).getMsgContent(), "      ");
                builder.append("    </message>\n");
                if (!((MsgType)msgType).getMsgType().equals("n")) continue;
                builder.append("    --> \n");
            }
            builder.append("  </messages>\n");
        }
        builder.append("  <components>\n");
        Map<String, Component> components = this.repository.getComponents();
        for (String string : componentsUsed) {
            Component component = components.get(string);
            builder.append("    <component name=\"").append(string).append("\">\n");
            Field numInGroup = null;
            for (Object o : component.getMsgContent()) {
                if (!(o instanceof Field) || !((Field)o).isNumInGroup()) continue;
                numInGroup = (Field)o;
                break;
            }
            if (numInGroup != null) {
                builder.append("      <group name=\"").append(numInGroup.getFieldName()).append("\" required=\"").append(numInGroup.isRequired() ? "Y" : "N").append("\">\n");
                this.addMsgContents(builder, component.getMsgContent(), "        ");
                builder.append("      </group>\n");
            } else {
                this.addMsgContents(builder, component.getMsgContent(), "      ");
            }
            builder.append("    </component>\n");
        }
        builder.append("  </components>\n");
        builder.append("  <fields>\n");
        Map<String, Field> fields = this.repository.getFields();
        for (Integer tagInt : fieldsUsed) {
            String tag = String.valueOf(tagInt);
            Field field = fields.get(tag);
            String fieldType = field.getType();
            builder.append("    <field number=\"").append(tag).append("\" name=\"").append(field.getFieldName()).append("\" type=\"").append(fieldType.toUpperCase()).append("\"");
            if (!field.getEnums().isEmpty()) {
                builder.append(">\n");
                HashSet<String> enumDescCache = new HashSet<String>();
                for (Enum theEnum : field.getEnums()) {
                    boolean add;
                    String enumDesc = theEnum.getDesc().toUpperCase();
                    enumDesc = enumDesc.replaceAll("\\(.*\\)", "");
                    enumDesc = enumDesc.replaceAll("'", "");
                    enumDesc = enumDesc.replaceAll("\"", "");
                    enumDesc = enumDesc.trim();
                    char firstChar = (enumDesc = enumDesc.replaceAll("\\W+", "_")).charAt(0);
                    if (Character.isDigit(firstChar)) {
                        enumDesc = "_" + enumDesc;
                    }
                    if (add = enumDescCache.add(enumDesc)) {
                        builder.append("      <value enum=\"").append(theEnum.getEnumName()).append("\" description=\"").append(enumDesc).append("\"/>\n");
                        continue;
                    }
                    enumDesc = enumDesc + "_1";
                    enumDescCache.add(enumDesc);
                    builder.append("      <value enum=\"").append(theEnum.getEnumName()).append("\" description=\"").append(enumDesc).append("\"/>\n");
                }
                builder.append("    </field>\n");
                continue;
            }
            builder.append("/>\n");
        }
        builder.append("  </fields>\n");
        builder.append("</fix>");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(dictionaryFile));
            bufferedWriter.write(builder.toString());
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addMsgContents(StringBuilder builder, List<Object> msgContents, String prefix) {
        for (Object o : msgContents) {
            Component component;
            if (o instanceof Field) {
                Field field = (Field)o;
                if (field.isNumInGroup()) continue;
                builder.append(prefix).append("<field name=\"").append(field.getFieldName()).append("\" required=\"").append(field.isRequired() ? "Y" : "N").append("\"/>\n");
                continue;
            }
            if (!(o instanceof Component) || (component = (Component)o).isStandardHeader() || component.isStandardTrailer()) continue;
            builder.append(prefix).append("<component name=\"").append(component.getName()).append("\" required=\"").append(component.isRequired() ? "Y" : "N").append("\"/>\n");
        }
    }

    private Set<Integer> getAllFieldsUsed(Map<String, MsgType> msgTypes) {
        Set<Integer> result = new TreeSet<Integer>();
        for (MsgType msgType : msgTypes.values()) {
            result = this.addFields(result, msgType.getMsgContent());
        }
        System.out.println("Fields used: " + result);
        return result;
    }

    private Set<Integer> addFields(Set<Integer> result, List<Object> msgContents) {
        for (Object o : msgContents) {
            if (o instanceof Field) {
                result.add(Integer.valueOf(((Field)o).getTag()));
            }
            if (!(o instanceof Component)) continue;
            result = this.addFields(result, ((Component)o).getMsgContent());
        }
        return result;
    }

    private Set<String> getAllComponentsUsed(Map<String, MsgType> msgTypes) {
        Set<String> result = new HashSet<String>();
        for (MsgType msgType : msgTypes.values()) {
            result = this.addComponents(result, msgType.getMsgContent());
        }
        System.out.println("Components used: " + result);
        return result;
    }

    private Set<String> addComponents(Set<String> result, List<Object> msgContents) {
        for (Object o : msgContents) {
            if (!(o instanceof Component)) continue;
            Component component = (Component)o;
            if (!component.isStandardHeader() && !component.isStandardTrailer()) {
                result.add(((Component)o).getName());
            }
            result = this.addComponents(result, ((Component)o).getMsgContent());
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 3) {
            System.err.println("Usage: Generator [repository path] [major number] [minor number]");
            System.exit(1);
            return;
        }
        File repository = new File(args[0]);
        if (!repository.exists() || !repository.isDirectory()) {
            System.err.println("Invalid repository: " + repository.getAbsolutePath());
            System.exit(1);
            return;
        }
        int major = Integer.valueOf(args[1]);
        int minor = Integer.valueOf(args[2]);
        new Generator(repository, major, minor).generate();
    }
}

