/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerWrapper
implements X509TrustManager {
    private final X509TrustManager trustManager;

    public static TrustManager[] wrap(TrustManager[] trustManagers) {
        TrustManager[] wrappers = new TrustManager[trustManagers.length];
        for (int i = 0; i < trustManagers.length; ++i) {
            TrustManager trustManager = trustManagers[i];
            wrappers[i] = trustManager instanceof X509TrustManager ? new X509TrustManagerWrapper((X509TrustManager)trustManager) : trustManager;
        }
        return wrappers;
    }

    public X509TrustManagerWrapper(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkClientTrusted(chain, authType);
        }
        catch (RuntimeException e) {
            throw new CertificateException("Unexpected error", e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (RuntimeException e) {
            throw new CertificateException("Unexpected error", e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

