/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Responder;
import quickfix.Session;

public class IoSessionResponder
implements Responder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IoSession ioSession;
    private final boolean synchronousWrites;
    private final long synchronousWriteTimeout;
    private final int maxScheduledWriteRequests;

    public IoSessionResponder(IoSession session, boolean synchronousWrites, long synchronousWriteTimeout, int maxScheduledWriteRequests) {
        this.ioSession = session;
        this.synchronousWrites = synchronousWrites;
        this.synchronousWriteTimeout = synchronousWriteTimeout;
        this.maxScheduledWriteRequests = maxScheduledWriteRequests;
    }

    @Override
    public boolean send(String data) {
        if (this.maxScheduledWriteRequests > 0 && this.ioSession.getScheduledWriteMessages() >= this.maxScheduledWriteRequests) {
            Session qfjSession = (Session)this.ioSession.getAttribute((Object)"QF_SESSION");
            try {
                qfjSession.disconnect("Slow consumer", true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        WriteFuture future = this.ioSession.write((Object)data);
        if (this.synchronousWrites) {
            try {
                if (!future.awaitUninterruptibly(this.synchronousWriteTimeout)) {
                    this.log.error("Synchronous write timed out after {}ms", (Object)this.synchronousWriteTimeout);
                    return false;
                }
            }
            catch (RuntimeException e) {
                this.log.error("Synchronous write failed: {}", (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public void disconnect() {
        this.ioSession.closeOnFlush();
        this.ioSession.setAttribute((Object)"QFJ_RESET_IO_CONNECTOR", (Object)Boolean.TRUE);
    }

    @Override
    public String getRemoteAddress() {
        SocketAddress remoteAddress = this.ioSession.getRemoteAddress();
        if (remoteAddress != null) {
            return remoteAddress.toString();
        }
        return null;
    }

    IoSession getIoSession() {
        return this.ioSession;
    }
}

