/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.quickfixj.CharsetSupport;
import quickfix.AbstractLog;
import quickfix.FileUtil;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

public class FileLog
extends AbstractLog {
    private static final byte[] TIME_STAMP_DELIMITER;
    private final String messagesFileName;
    private final String eventFileName;
    private boolean syncAfterWrite;
    private final Object messagesLock = new Object();
    private final Object eventsLock = new Object();
    private FileOutputStream messages;
    private FileOutputStream events;
    private final boolean includeMillis;
    private final boolean includeTimestampForMessages;

    FileLog(String path, SessionID sessionID, boolean includeMillis, boolean includeTimestampForMessages, boolean logHeartbeats) throws FileNotFoundException {
        String sessionName = FileUtil.sessionIdFileName(sessionID);
        this.setLogHeartbeats(logHeartbeats);
        String prefix = FileUtil.fileAppendPath(path, sessionName + ".");
        this.messagesFileName = prefix + "messages.log";
        this.eventFileName = prefix + "event.log";
        File directory = new File(this.messagesFileName).getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.includeMillis = includeMillis;
        this.includeTimestampForMessages = includeTimestampForMessages;
        this.openLogStreams(true);
    }

    private void openLogStreams(boolean append) throws FileNotFoundException {
        this.messages = new FileOutputStream(this.messagesFileName, append);
        this.events = new FileOutputStream(this.eventFileName, append);
    }

    @Override
    protected void logIncoming(String message) {
        this.writeMessage(this.messages, this.messagesLock, message, false);
    }

    @Override
    protected void logOutgoing(String message) {
        this.writeMessage(this.messages, this.messagesLock, message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessage(FileOutputStream stream, Object lock, String message, boolean forceTimestamp) {
        try {
            Object object = lock;
            synchronized (object) {
                if (forceTimestamp || this.includeTimestampForMessages) {
                    this.writeTimeStamp(stream);
                }
                stream.write(message.getBytes(CharsetSupport.getCharset()));
                stream.write(10);
                stream.flush();
                if (this.syncAfterWrite) {
                    stream.getFD().sync();
                }
            }
        }
        catch (IOException e) {
            System.err.println("error writing message to log : " + message);
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void onEvent(String message) {
        this.writeMessage(this.events, this.eventsLock, message, true);
    }

    @Override
    public void onErrorEvent(String message) {
        this.writeMessage(this.events, this.eventsLock, message, true);
    }

    private void writeTimeStamp(OutputStream out) throws IOException {
        String formattedTime = UtcTimestampConverter.convert(SystemTime.getDate(), this.includeMillis);
        out.write(formattedTime.getBytes(CharsetSupport.getCharset()));
        out.write(TIME_STAMP_DELIMITER);
    }

    String getEventFileName() {
        return this.eventFileName;
    }

    String getMessagesFileName() {
        return this.messagesFileName;
    }

    public void setSyncAfterWrite(boolean syncAfterWrite) {
        this.syncAfterWrite = syncAfterWrite;
    }

    public void closeFiles() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        this.messages.close();
        this.events.close();
    }

    @Override
    public void clear() {
        try {
            this.close();
            this.openLogStreams(false);
        }
        catch (IOException e) {
            System.err.println("Could not clear log: " + this.getClass().getName());
        }
    }

    static {
        try {
            TIME_STAMP_DELIMITER = ": ".getBytes(CharsetSupport.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

