/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.dictgenerator;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.quickfixj.dictgenerator.Component;
import org.quickfixj.dictgenerator.ComponentComponent;
import org.quickfixj.dictgenerator.ComponentField;
import org.quickfixj.dictgenerator.Enum;
import org.quickfixj.dictgenerator.Field;
import org.quickfixj.dictgenerator.MsgType;
import org.quickfixj.dictgenerator.MsgTypeComponent;
import org.quickfixj.dictgenerator.MsgTypeField;

public class Repository {
    private final File repository;
    private final Document components;
    private final Document enums;
    private final Document fields;
    private final Document msgContents;
    private final Document msgType;
    private final Map<String, MsgType> sessionMsgTypes = new TreeMap<String, MsgType>();
    private final Map<String, MsgType> applicationMsgTypes = new TreeMap<String, MsgType>();
    private final Map<String, Field> allFields = new TreeMap<String, Field>();
    private final Map<String, Component> allComponents = new TreeMap<String, Component>();

    public Repository(File repositoryFile) throws Exception {
        this.repository = repositoryFile;
        HashSet<String> requiredFiles = new HashSet<String>();
        requiredFiles.add("Components.xml");
        requiredFiles.add("Enums.xml");
        requiredFiles.add("Fields.xml");
        requiredFiles.add("MsgContents.xml");
        requiredFiles.add("MsgType.xml");
        for (File file : this.repository.listFiles()) {
            if (!requiredFiles.contains(file.getName())) continue;
            requiredFiles.remove(file.getName());
        }
        if (!requiredFiles.isEmpty()) {
            throw new Exception("Invalid repository: Missing required files: " + requiredFiles);
        }
        SAXReader reader = new SAXReader();
        this.components = reader.read(new File(this.repository, "Components.xml"));
        this.enums = reader.read(new File(this.repository, "Enums.xml"));
        this.fields = reader.read(new File(this.repository, "Fields.xml"));
        this.msgContents = reader.read(new File(this.repository, "MsgContents.xml"));
        this.msgType = reader.read(new File(this.repository, "MsgType.xml"));
        this.initFields();
        this.initComponents();
        this.initMsgTypes(this.sessionMsgTypes, "1");
        this.initMsgTypes(this.applicationMsgTypes, "0");
    }

    public final Map<String, MsgType> getSessionMsgTypes() {
        return this.sessionMsgTypes;
    }

    public final Component getStandardHeader(MsgType msgType) {
        for (Object o : msgType.getMsgContent()) {
            if (!(o instanceof Component) || !((Component)o).isStandardHeader()) continue;
            return (Component)o;
        }
        return null;
    }

    public final Component getStandardTrailer(MsgType msgType) {
        for (Object o : msgType.getMsgContent()) {
            if (!(o instanceof Component) || !((Component)o).isStandardTrailer()) continue;
            return (Component)o;
        }
        return null;
    }

    public final Map<String, MsgType> getApplicationMsgTypes() {
        return this.applicationMsgTypes;
    }

    public final Map<String, Field> getFields() {
        return this.allFields;
    }

    public final Map<String, Component> getComponents() {
        return this.allComponents;
    }

    private void initMsgTypes(Map<String, MsgType> msgTypeMap, String notReqXML) {
        System.out.println(this.getClass().getSimpleName() + ": Init MsgTypes (" + notReqXML + ")...");
        List msgTypeNodes = this.msgType.selectNodes("//dataroot/MsgType[NotReqXML=" + notReqXML + "]");
        for (Object o : msgTypeNodes) {
            Node node = (Node)o;
            String msgID = node.selectSingleNode("MsgID").getText();
            String messageName = node.selectSingleNode("MessageName").getText();
            String componentType = node.selectSingleNode("ComponentType").getText();
            String category = node.selectSingleNode("Category").getText();
            String msgType = node.selectSingleNode("MsgType").getText();
            msgTypeMap.put(msgType, new MsgType(msgID, messageName, componentType, category, notReqXML, msgType));
        }
        System.out.println(this.getClass().getSimpleName() + ": " + msgTypeMap.size() + " MsgTypes found");
        for (MsgType msgType : msgTypeMap.values()) {
            List<?> msgContentsNodes = this.getMsgContents(msgType.getMsgID());
            System.out.println("\t " + msgType.getName());
            for (Object o : msgContentsNodes) {
                Node node = (Node)o;
                String tagText = node.selectSingleNode("TagText").getText();
                String reqd = node.selectSingleNode("Reqd").getText();
                if (this.allFields.containsKey(tagText)) {
                    MsgTypeField msgTypeField = new MsgTypeField(this.allFields.get(tagText), reqd);
                    msgType.addMsgContent(msgTypeField);
                    System.out.println("\t\t " + this.allFields.get(tagText).getFieldName());
                    continue;
                }
                if (this.allComponents.containsKey(tagText)) {
                    MsgTypeComponent msgTypeComponent = new MsgTypeComponent(this.allComponents.get(tagText), reqd);
                    msgType.addMsgContent(msgTypeComponent);
                    System.out.println("\t\t " + this.allComponents.get(tagText).getName());
                    continue;
                }
                System.err.println("Could not find tagText: " + tagText);
            }
        }
    }

    private void initFields() {
        System.out.println(this.getClass().getSimpleName() + ": Init Fields...");
        List fieldNodes = this.fields.selectNodes("//dataroot/Fields");
        for (Object o : fieldNodes) {
            Node node = (Node)o;
            String tag = node.selectSingleNode("Tag").getText();
            String fieldName = node.selectSingleNode("FieldName").getText();
            System.out.println("\t " + fieldName + "(" + tag + ")");
            String type = node.selectSingleNode("Type").getText();
            String desc = node.selectSingleNode("Desc").getText();
            String notReqXML = node.selectSingleNode("NotReqXML").getText();
            Field field = new Field(tag, fieldName, type, desc, notReqXML);
            this.allFields.put(field.getTag(), field);
            List enumNodes = this.enums.selectNodes("//dataroot/Enums[Tag=" + tag + "]");
            Collections.sort(enumNodes, new EnumNodeComparator());
            if (enumNodes.isEmpty()) continue;
            for (Object enumO : enumNodes) {
                Node enumNode = (Node)enumO;
                String enumName = enumNode.selectSingleNode("Enum").getText();
                System.out.println("\t\t " + enumName);
                String enumDesc = enumNode.selectSingleNode("Description").getText();
                field.addEnum(new Enum(enumName, enumDesc));
            }
        }
        System.out.println(this.getClass().getSimpleName() + ": " + this.allFields.size() + " Fields found");
    }

    private void initComponents() {
        System.out.println(this.getClass().getSimpleName() + ": Init Components...");
        List componentNodes = this.components.selectNodes("//dataroot/Components");
        for (Object o : componentNodes) {
            Node node = (Node)o;
            String msgID = node.selectSingleNode("MsgID").getText();
            String componentName = node.selectSingleNode("ComponentName").getText();
            String componentType = node.selectSingleNode("ComponentType").getText();
            String category = node.selectSingleNode("Category").getText();
            String notReqXML = node.selectSingleNode("NotReqXML").getText();
            this.allComponents.put(componentName, new Component(msgID, componentName, componentType, category, notReqXML));
        }
        System.out.println(this.getClass().getSimpleName() + ": " + this.allComponents.size() + " Components found");
        for (Component component : this.allComponents.values()) {
            this.addComponentMsgContent(component, "\t");
        }
    }

    private void addComponentMsgContent(Component component, String prefix) {
        List<?> msgContentsNodes = this.getMsgContents(component.getMsgID());
        System.out.println(prefix + " " + component.getName());
        if (!component.getMsgContent().isEmpty()) {
            System.out.println(prefix + "\talready handled, return");
            return;
        }
        for (Object o : msgContentsNodes) {
            Node node = (Node)o;
            String tagText = node.selectSingleNode("TagText").getText();
            String reqd = node.selectSingleNode("Reqd").getText();
            if (this.allFields.containsKey(tagText)) {
                ComponentField componentField = new ComponentField(this.allFields.get(tagText), reqd);
                component.addMsgContent(componentField);
                System.out.println(prefix + "\t " + this.allFields.get(tagText).getFieldName());
                continue;
            }
            if (this.allComponents.containsKey(tagText)) {
                this.addComponentMsgContent(this.allComponents.get(tagText), prefix + "\t");
                ComponentComponent componentComponent = new ComponentComponent(this.allComponents.get(tagText), reqd);
                component.addMsgContent(componentComponent);
                System.out.println(prefix + "\t " + this.allComponents.get(tagText).getName());
                continue;
            }
            System.err.println("Could not find tagText: " + tagText);
        }
    }

    private List<?> getMsgContents(String msgID) {
        List nodes = this.msgContents.selectNodes("//dataroot/MsgContents[MsgID=" + msgID + "]");
        Collections.sort(nodes, new MsgContentNodeComparator());
        return nodes;
    }

    class EnumNodeComparator
    implements Comparator<Object> {
        EnumNodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            try {
                Double pos1 = Double.parseDouble(((Node)o1).selectSingleNode("Sort").getText());
                Double pos2 = Double.parseDouble(((Node)o2).selectSingleNode("Sort").getText());
                return pos1.compareTo(pos2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    class MsgContentNodeComparator
    implements Comparator<Object> {
        MsgContentNodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            try {
                Double pos1 = Double.parseDouble(((Node)o1).selectSingleNode("Position").getText());
                Double pos2 = Double.parseDouble(((Node)o2).selectSingleNode("Position").getText());
                return pos1.compareTo(pos2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

