/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.codegenerator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.quickfixj.codegenerator.CodeGenerationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MessageCodeGenerator {
    private static final String BIGDECIMAL_TYPE_OPTION = "generator.decimal";
    private static final String ORDERED_FIELDS_OPTION = "generator.orderedFields";
    private static final String OVERWRITE_OPTION = "generator.overwrite";
    private static final long SERIAL_UID = 20050617L;
    private static final String SERIAL_UID_STR = Long.toString(20050617L);
    private static final String XSLPARAM_SERIAL_UID = "serialVersionUID";
    private final Map<String, Document> specificationCache = new HashMap<String, Document>();

    protected void logInfo(String msg) {
        System.out.println(msg);
    }

    protected void logDebug(String msg) {
        System.out.println(msg);
    }

    protected void logError(String msg, Throwable e) {
        System.err.println(msg);
        e.printStackTrace();
    }

    private void generateMessageBaseClass(Task task) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.logInfo(task.getName() + ": generating message base class");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(XSLPARAM_SERIAL_UID, SERIAL_UID_STR);
        this.generateClassCode(task, "Message", parameters);
    }

    private void generateMessageFactoryClass(Task task) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.generateClassCode(task, "MessageFactory", null);
    }

    private void generateMessageCrackerClass(Task task) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.generateClassCode(task, "MessageCracker", null);
    }

    private void generateClassCode(Task task, String className, Map<String, String> parameters) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.logDebug("generating " + className + " for " + task.getName());
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("messagePackage", task.getMessagePackage());
        parameters.put("fieldPackage", task.getFieldPackage());
        Document document = this.getSpecification(task);
        this.generateCodeFile(task, document, parameters, task.getOutputBaseDirectory() + "/" + task.getMessageDirectory() + "/" + className + ".java", this.createTransformer(task, className + ".xsl"));
    }

    private void generateFieldClasses(Task task) throws ParserConfigurationException, SAXException, IOException {
        String outputDirectory = task.getOutputBaseDirectory() + "/" + task.getFieldDirectory() + "/";
        this.logInfo(task.getName() + ": generating field classes in " + outputDirectory);
        this.writePackageDocumentation(outputDirectory, "FIX field definitions for " + task.getName());
        Document document = this.getSpecification(task);
        List<String> fieldNames = this.getNames(document.getDocumentElement(), "fields/field");
        try {
            Transformer transformer = this.createTransformer(task, "Fields.xsl");
            for (String fieldName : fieldNames) {
                String outputFile = outputDirectory + fieldName + ".java";
                if (new File(outputFile).exists()) continue;
                this.logDebug("field: " + fieldName);
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("fieldName", fieldName);
                parameters.put("fieldPackage", task.getFieldPackage());
                if (task.isDecimalGenerated()) {
                    parameters.put("decimalType", "java.math.BigDecimal");
                    parameters.put("decimalConverter", "Decimal");
                }
                parameters.put(XSLPARAM_SERIAL_UID, SERIAL_UID_STR);
                this.generateCodeFile(task, document, parameters, outputFile, transformer);
            }
        }
        catch (Exception e) {
            this.logError("error while generating field classes", e);
        }
    }

    private void generateMessageSubclasses(Task task) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.logInfo(task.getName() + ": generating message subclasses");
        String outputDirectory = task.getOutputBaseDirectory() + "/" + task.getMessageDirectory() + "/";
        this.writePackageDocumentation(outputDirectory, "Message classes");
        Document document = this.getSpecification(task);
        List<String> messageNames = this.getNames(document.getDocumentElement(), "messages/message");
        Transformer transformer = this.createTransformer(task, "MessageSubclass.xsl");
        for (String messageName : messageNames) {
            this.logDebug("generating message class: " + messageName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("itemName", messageName);
            parameters.put(XSLPARAM_SERIAL_UID, SERIAL_UID_STR);
            parameters.put("orderedFields", Boolean.toString(task.isOrderedFields()));
            parameters.put("fieldPackage", task.getFieldPackage());
            parameters.put("messagePackage", task.getMessagePackage());
            this.generateCodeFile(task, document, parameters, outputDirectory + messageName + ".java", transformer);
        }
    }

    private void generateComponentClasses(Task task) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.logInfo(task.getName() + ": generating component classes");
        String outputDirectory = task.getOutputBaseDirectory() + "/" + task.getMessageDirectory() + "/component/";
        Document document = this.getSpecification(task);
        List<String> componentNames = this.getNames(document.getDocumentElement(), "components/component");
        if (componentNames.size() > 0) {
            this.writePackageDocumentation(outputDirectory, "Message component classes");
        }
        Transformer transformer = this.createTransformer(task, "MessageSubclass.xsl");
        for (String componentName : componentNames) {
            this.logDebug("generating component class: " + componentName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("itemName", componentName);
            parameters.put("baseClass", "quickfix.MessageComponent");
            parameters.put("subpackage", ".component");
            parameters.put("fieldPackage", task.getFieldPackage());
            parameters.put("messagePackage", task.getMessagePackage());
            parameters.put("orderedFields", Boolean.toString(task.isOrderedFields()));
            parameters.put(XSLPARAM_SERIAL_UID, SERIAL_UID_STR);
            this.generateCodeFile(task, document, parameters, outputDirectory + componentName + ".java", transformer);
        }
    }

    private Transformer createTransformer(Task task, String xsltFile) throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        StreamSource styleSource;
        File xslt = new File(task.getTransformDirectory() + "/" + xsltFile);
        if (xslt.exists()) {
            styleSource = new StreamSource(xslt);
        } else {
            this.logInfo("Loading predefined xslt file:" + xsltFile);
            styleSource = new StreamSource(this.getClass().getResourceAsStream(xsltFile));
        }
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
        return transformerFactory.newTransformer(styleSource);
    }

    private Document getSpecification(Task task) throws ParserConfigurationException, SAXException, IOException {
        Document document = this.specificationCache.get(task.getName());
        if (document == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(task.getSpecification());
            this.specificationCache.put(task.getName(), document);
        }
        return document;
    }

    private void writePackageDocumentation(String outputDirectory, String description) throws FileNotFoundException {
        File packageDescription = new File(outputDirectory + "package.html");
        File parentDirectory = packageDescription.getParentFile();
        if (!parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        PrintStream out = new PrintStream(new FileOutputStream(packageDescription));
        out.println("<html>");
        out.println("<head><title/></head>");
        out.println("<body>" + description + "</body>");
        out.println("</html>");
        out.close();
    }

    private List<String> getNames(Element element, String path) {
        return this.getNames(element, path, new ArrayList<String>());
    }

    private List<String> getNames(Element element, String path, List<String> names) {
        int separatorOffset = path.indexOf("/");
        if (separatorOffset == -1) {
            NodeList fieldNodeList = element.getElementsByTagName(path);
            for (int i = 0; i < fieldNodeList.getLength(); ++i) {
                names.add(((Element)fieldNodeList.item(i)).getAttribute("name"));
            }
        } else {
            String tag = path.substring(0, separatorOffset);
            NodeList subnodes = element.getElementsByTagName(tag);
            for (int i = 0; i < subnodes.getLength(); ++i) {
                this.getNames((Element)subnodes.item(i), path.substring(separatorOffset + 1), names);
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCodeFile(Task task, Document document, Map<String, String> parameters, String outputFileName, Transformer transformer) throws TransformerFactoryConfigurationError, FileNotFoundException, TransformerException {
        File outputFile;
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }
        if (!(outputFile = new File(outputFileName)).getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        if (outputFile.exists()) {
            if (!task.isOverwrite()) {
                return;
            }
            if (outputFile.lastModified() > task.getSpecificationLastModified()) {
                this.logDebug("Skipping file " + outputFile.getName());
                return;
            }
        }
        this.logDebug("spec has mod " + task.getSpecificationLastModified() + " output has mod " + outputFile.lastModified());
        DOMSource source = new DOMSource(document);
        FileOutputStream fos = new FileOutputStream(outputFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            StreamResult result = new StreamResult(bos);
            transformer.transform(source, result);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ioe) {
                this.logError("error closing " + outputFile, ioe);
            }
        }
    }

    public void generate(Task task) {
        try {
            this.generateFieldClasses(task);
            this.generateMessageBaseClass(task);
            this.generateMessageFactoryClass(task);
            this.generateMessageCrackerClass(task);
            this.generateComponentClasses(task);
            this.generateMessageSubclasses(task);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    public static void main(String[] args) {
        MessageCodeGenerator codeGenerator = new MessageCodeGenerator();
        try {
            String[] versions;
            if (args.length != 3) {
                String classname = MessageCodeGenerator.class.getName();
                System.err.println("usage: " + classname + " specDir xformDir outputBaseDir");
                return;
            }
            boolean overwrite = MessageCodeGenerator.getOption(OVERWRITE_OPTION, true);
            boolean orderedFields = MessageCodeGenerator.getOption(ORDERED_FIELDS_OPTION, false);
            boolean useDecimal = MessageCodeGenerator.getOption(BIGDECIMAL_TYPE_OPTION, false);
            long start = System.currentTimeMillis();
            for (String ver : versions = new String[]{"FIXT 1.1", "FIX 5.0", "FIX 4.4", "FIX 4.3", "FIX 4.2", "FIX 4.1", "FIX 4.0"}) {
                Task task = new Task();
                task.setName(ver);
                String version = ver.replaceAll("[ .]", "");
                task.setSpecification(new File(args[0] + "/" + version + ".xml"));
                task.setTransformDirectory(new File(args[1]));
                task.setMessagePackage("quickfix." + version.toLowerCase());
                task.setOutputBaseDirectory(new File(args[2]));
                task.setFieldPackage("quickfix.field");
                task.setOverwrite(overwrite);
                task.setOrderedFields(orderedFields);
                task.setDecimalGenerated(useDecimal);
                codeGenerator.generate(task);
            }
            double duration = System.currentTimeMillis() - start;
            DecimalFormat durationFormat = new DecimalFormat("#.###");
            codeGenerator.logInfo("Time for generation: " + durationFormat.format(duration / 1000.0) + " seconds");
        }
        catch (Exception e) {
            codeGenerator.logError("error during code generation", e);
            System.exit(1);
        }
    }

    private static boolean getOption(String key, boolean defaultValue) {
        return System.getProperties().containsKey(key) ? Boolean.getBoolean(key) : defaultValue;
    }

    public static class Task {
        private String name;
        private File specification;
        private File outputBaseDirectory;
        private String messagePackage;
        private String fieldPackage;
        private boolean overwrite = true;
        private File transformDirectory;
        private boolean orderedFields;
        private boolean useDecimal;
        private long specificationLastModified;

        public long getSpecificationLastModified() {
            return this.specificationLastModified;
        }

        public String getName() {
            return this.name;
        }

        public void setOrderedFields(boolean orderedFields) {
            this.orderedFields = orderedFields;
        }

        public boolean isOrderedFields() {
            return this.orderedFields;
        }

        public File getTransformDirectory() {
            return this.transformDirectory;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFieldPackage() {
            return this.fieldPackage;
        }

        public String getFieldDirectory() {
            return this.fieldPackage.replace('.', '/');
        }

        public void setFieldPackage(String fieldPackage) {
            this.fieldPackage = fieldPackage;
        }

        public String getMessageDirectory() {
            return this.messagePackage.replace('.', '/');
        }

        public String getMessagePackage() {
            return this.messagePackage;
        }

        public void setMessagePackage(String messagePackage) {
            this.messagePackage = messagePackage;
        }

        public File getOutputBaseDirectory() {
            return this.outputBaseDirectory;
        }

        public void setOutputBaseDirectory(File outputDirectory) {
            this.outputBaseDirectory = outputDirectory;
        }

        public File getSpecification() {
            return this.specification;
        }

        public void setSpecification(File dictFile) {
            this.specification = dictFile;
            this.specificationLastModified = dictFile.lastModified();
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public void setTransformDirectory(File schemaDirectory) {
            this.transformDirectory = schemaDirectory;
        }

        public void setDecimalGenerated(boolean useDecimal) {
            this.useDecimal = useDecimal;
        }

        public boolean isDecimalGenerated() {
            return this.useDecimal;
        }
    }
}

