/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.ThreadPerSessionEventHandlingStrategy;
import quickfix.mina.acceptor.AbstractSocketAcceptor;

public class ThreadedSocketAcceptor
extends AbstractSocketAcceptor {
    private final ThreadPerSessionEventHandlingStrategy eventHandlingStrategy;

    public ThreadedSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    public ThreadedSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    public ThreadedSocketAcceptor(SessionFactory sessionFactory, SessionSettings settings, int queueCapacity) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketAcceptor(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    @Override
    public void start() throws ConfigError, RuntimeError {
        this.startAcceptingConnections();
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void stop(boolean forceDisconnect) {
        try {
            this.stopAcceptingConnections();
        }
        catch (ConfigError e) {
            this.log.error("Error when stopping acceptor.", (Throwable)e);
        }
        this.logoutAllSessions(forceDisconnect);
        this.stopSessionTimer();
        this.eventHandlingStrategy.stopDispatcherThreads();
        Session.unregisterSessions(this.getSessions());
    }

    @Override
    public void block() throws ConfigError, RuntimeError {
        throw new UnsupportedOperationException("Blocking not supported: " + this.getClass());
    }

    @Override
    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }
}

