/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SingleThreadedEventHandlingStrategy;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class SocketInitiator
extends AbstractSocketInitiator {
    private Boolean isStarted = Boolean.FALSE;
    private final Object lock = new Object();
    private final SingleThreadedEventHandlingStrategy eventHandlingStrategy;

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketInitiator(SessionFactory sessionFactory, SessionSettings settings, int queueCapacity) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    @Override
    public void block() throws ConfigError, RuntimeError {
        this.initialize(false);
    }

    @Override
    public void start() throws ConfigError, RuntimeError {
        this.initialize(true);
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean forceDisconnect) {
        this.eventHandlingStrategy.stopHandlingMessages();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.logoutAllSessions(forceDisconnect);
                this.stopInitiators();
            }
            finally {
                Session.unregisterSessions(this.getSessions());
                this.isStarted = Boolean.FALSE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean blockInThread) throws ConfigError {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStarted.equals(Boolean.FALSE)) {
                this.createSessionInitiators();
                for (Session session : this.getSessionMap().values()) {
                    Session.registerSession(session);
                }
                this.startInitiators();
                if (blockInThread) {
                    this.eventHandlingStrategy.blockInThread();
                    this.isStarted = Boolean.TRUE;
                } else {
                    this.isStarted = Boolean.TRUE;
                    this.eventHandlingStrategy.block();
                }
            } else {
                this.log.warn("Ignored attempt to start already running SocketInitiator.");
            }
        }
    }

    @Override
    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }
}

