/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.maven.rust;

import io.questdb.jar.jni.Platform;
import io.questdb.jar.jni.PlatformConventions;
import io.questdb.maven.rust.CargoInstalledChecker;
import io.questdb.maven.rust.Shlex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlInvalidTypeException;
import org.tomlj.TomlTable;

public class Crate {
    private final Path crateRoot;
    private final Path targetDir;
    private final Params params;
    private final TomlTable cargoToml;
    private final String packageName;
    private Log log = Crate.nullLog();

    public Crate(Path crateRoot, Path targetRootDir, Params params) throws MojoExecutionException {
        this.crateRoot = crateRoot;
        this.targetDir = targetRootDir.resolve(this.getDirName());
        this.params = params;
        Path tomlPath = crateRoot.resolve("Cargo.toml");
        if (!Files.exists(tomlPath, LinkOption.NOFOLLOW_LINKS)) {
            throw new MojoExecutionException("Cargo.toml file expected under: " + crateRoot);
        }
        try {
            this.cargoToml = Toml.parse((Path)tomlPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse Cargo.toml file: " + e.getMessage());
        }
        try {
            this.packageName = this.cargoToml.getString("package.name");
            if (this.packageName == null) {
                throw new MojoExecutionException("Missing required `package.name` from Cargo.toml file");
            }
        }
        catch (TomlInvalidTypeException e) {
            throw new MojoExecutionException("Failed to extract `package.name` from Cargo.toml file: " + e.getMessage());
        }
    }

    public static String pinLibName(String name) {
        return PlatformConventions.LIB_PREFIX + name.replace('-', '_') + PlatformConventions.LIB_SUFFIX;
    }

    public static String pinBinName(String name) {
        return name + PlatformConventions.EXE_SUFFIX;
    }

    public static Log nullLog() {
        return new Log(){

            public void debug(CharSequence content) {
            }

            public void debug(CharSequence content, Throwable error) {
            }

            public void debug(Throwable error) {
            }

            public void error(CharSequence content) {
            }

            public void error(CharSequence content, Throwable error) {
            }

            public void error(Throwable error) {
            }

            public void info(CharSequence content) {
            }

            public void info(CharSequence content, Throwable error) {
            }

            public void info(Throwable error) {
            }

            public boolean isDebugEnabled() {
                return false;
            }

            public boolean isErrorEnabled() {
                return false;
            }

            public boolean isInfoEnabled() {
                return false;
            }

            public boolean isWarnEnabled() {
                return false;
            }

            public void warn(CharSequence content) {
            }

            public void warn(CharSequence content, Throwable error) {
            }

            public void warn(Throwable error) {
            }
        };
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private String getDirName() {
        return this.crateRoot.getFileName().toString();
    }

    private String getProfile() {
        return this.params.release ? "release" : "debug";
    }

    public boolean hasCdylib() {
        try {
            TomlArray crateTypes = this.getCrateTypes();
            if (crateTypes == null) {
                return false;
            }
            for (int index = 0; index < crateTypes.size(); ++index) {
                String crateType = crateTypes.getString(index);
                if (crateType == null || !crateType.equals("cdylib")) continue;
                return true;
            }
            return false;
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
    }

    private TomlArray getCrateTypes() {
        TomlArray crateTypes = this.cargoToml.getArray("lib.crate-type");
        if (crateTypes == null) {
            String crateTypeLegacyKey = "lib.crate_type";
            return this.cargoToml.getArray(crateTypeLegacyKey);
        }
        return crateTypes;
    }

    private String getCdylibName() throws MojoExecutionException {
        String name;
        try {
            name = this.cargoToml.getString("lib.name");
        }
        catch (TomlInvalidTypeException e) {
            throw new MojoExecutionException("Failed to extract `lib.name` from Cargo.toml file: " + e.getMessage());
        }
        if (name == null && this.hasCdylib()) {
            name = this.packageName;
        }
        return name;
    }

    private List<String> getBinNames() throws MojoExecutionException {
        TomlArray bins;
        ArrayList<String> binNames = new ArrayList<String>();
        String defaultBin = null;
        if (Files.exists(this.crateRoot.resolve("src").resolve("main.rs"), new LinkOption[0])) {
            defaultBin = this.packageName;
            binNames.add(defaultBin);
        }
        try {
            bins = this.cargoToml.getArray("bin");
        }
        catch (TomlInvalidTypeException e) {
            throw new MojoExecutionException("Failed to extract `bin`s from Cargo.toml file: " + e.getMessage());
        }
        if (bins == null) {
            return binNames;
        }
        for (int index = 0; index < bins.size(); ++index) {
            String path;
            String name;
            TomlTable bin = bins.getTable(index);
            if (bin == null) {
                throw new MojoExecutionException("Failed to extract `bin`s from Cargo.toml file: expected a `bin` table at index " + index);
            }
            try {
                name = bin.getString("name");
            }
            catch (TomlInvalidTypeException e) {
                throw new MojoExecutionException("Failed to extract `bin`s from Cargo.toml file: expected a string at index " + index + " `name` key");
            }
            if (name == null) {
                throw new MojoExecutionException("Failed to extract `bin`s from Cargo.toml file: missing `name` key at `bin` with index " + index);
            }
            try {
                path = bin.getString("path");
            }
            catch (TomlInvalidTypeException e) {
                throw new MojoExecutionException("Failed to extract `bin`s from Cargo.toml file: expected a string at index " + index + " `path` key");
            }
            if (path != null && path.equals("src/main.rs")) {
                defaultBin = name;
                binNames.remove(0);
                binNames.add(0, defaultBin);
            }
            if (name.equals(defaultBin)) continue;
            binNames.add(name);
        }
        return binNames;
    }

    public List<Path> getArtifactPaths() throws MojoExecutionException {
        ArrayList<Path> paths = new ArrayList<Path>();
        String profile = this.getProfile();
        String libName = this.getCdylibName();
        if (libName != null) {
            Path libPath = this.targetDir.resolve(profile).resolve(Crate.pinLibName(libName));
            paths.add(libPath);
        }
        for (String binName : this.getBinNames()) {
            Path binPath = this.targetDir.resolve(profile).resolve(Crate.pinBinName(binName));
            paths.add(binPath);
        }
        return paths;
    }

    private String getCargoPath() {
        String path = this.params.cargoPath;
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (!isWindows && path.startsWith("~/")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        return path;
    }

    private void runCommand(List<String> args) throws IOException, InterruptedException, MojoExecutionException {
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        processBuilder.environment().putAll(this.params.environmentVariables);
        processBuilder.directory(this.crateRoot.toFile());
        Process process = processBuilder.start();
        Executors.newSingleThreadExecutor().submit(() -> new BufferedReader(new InputStreamReader(process.getInputStream())).lines().forEach(arg_0 -> ((Log)this.log).info(arg_0)));
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new MojoExecutionException("Cargo command failed with exit code " + exitCode);
        }
    }

    private void cargo(List<String> args) throws MojoExecutionException, MojoFailureException {
        String cargoPath = this.getCargoPath();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(cargoPath);
        cmd.addAll(args);
        this.log.info((CharSequence)("Working directory: " + this.crateRoot));
        if (!this.params.environmentVariables.isEmpty()) {
            this.log.info((CharSequence)"Environment variables:");
            for (String key : this.params.environmentVariables.keySet()) {
                this.log.info((CharSequence)("  " + key + "=" + Shlex.quote(this.params.environmentVariables.get(key))));
            }
        }
        this.log.info((CharSequence)("Running: " + Shlex.quote(cmd)));
        try {
            this.runCommand(cmd);
        }
        catch (IOException | InterruptedException e) {
            CargoInstalledChecker.INSTANCE.check(cargoPath);
            throw new MojoFailureException("Failed to invoke cargo", (Throwable)e);
        }
    }

    private void addCargoArgs(List<String> args) {
        CharSequence[] cleanedFeatures;
        if (this.params.verbosity != null) {
            args.add(this.params.verbosity);
        }
        args.add("--target-dir");
        args.add(this.targetDir.toAbsolutePath().toString());
        if (this.params.release) {
            args.add("--release");
        }
        if (this.params.allFeatures) {
            args.add("--all-features");
        }
        if (this.params.noDefaultFeatures) {
            args.add("--no-default-features");
        }
        if ((cleanedFeatures = this.params.cleanedFeatures()).length > 0) {
            args.add("--features");
            args.add(String.join((CharSequence)",", cleanedFeatures));
        }
        if (this.params.tests) {
            args.add("--tests");
        }
        if (this.params.extraArgs != null) {
            Collections.addAll(args, this.params.extraArgs);
        }
    }

    public void build() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("build");
        this.addCargoArgs(args);
        this.cargo(args);
    }

    public void test() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("test");
        this.addCargoArgs(args);
        this.cargo(args);
    }

    private Path resolveCopyToDir() throws MojoExecutionException {
        Path copyToDir = this.params.copyToDir;
        if (copyToDir == null) {
            return null;
        }
        if (this.params.copyWithPlatformDir) {
            copyToDir = copyToDir.resolve(Platform.RESOURCE_PREFIX);
        }
        if (!Files.exists(copyToDir, LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.createDirectories(copyToDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create directory " + copyToDir + ": " + e.getMessage(), (Exception)e);
            }
        }
        if (!Files.isDirectory(copyToDir, new LinkOption[0])) {
            throw new MojoExecutionException(copyToDir + " is not a directory");
        }
        return copyToDir;
    }

    public void copyArtifacts() throws MojoExecutionException {
        Path copyToDir = this.resolveCopyToDir();
        if (copyToDir == null) {
            return;
        }
        List<Path> artifactPaths = this.getArtifactPaths();
        this.log.info((CharSequence)("Copying " + this.getDirName() + "'s artifacts to " + Shlex.quote(copyToDir.toAbsolutePath().toString())));
        for (Path artifactPath : artifactPaths) {
            Path fileName = artifactPath.getFileName();
            Path destPath = copyToDir.resolve(fileName);
            try {
                Files.copy(artifactPath, destPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy " + artifactPath + " to " + copyToDir + ":" + e.getMessage());
            }
            this.log.info((CharSequence)("Copied " + Shlex.quote(fileName.toString())));
        }
    }

    public static class Params {
        public String verbosity;
        public HashMap<String, String> environmentVariables;
        public String cargoPath;
        public boolean release;
        public String[] features;
        public boolean allFeatures;
        public boolean noDefaultFeatures;
        public boolean tests;
        public String[] extraArgs;
        public Path copyToDir;
        public boolean copyWithPlatformDir;

        public String[] cleanedFeatures() {
            if (this.features == null || this.features.length == 0) {
                return new String[0];
            }
            ArrayList<String> cleanedFeatures = new ArrayList<String>();
            for (String feature : this.features) {
                if (feature == null || (feature = feature.trim()).isEmpty()) continue;
                cleanedFeatures.add(feature);
            }
            return cleanedFeatures.toArray(new String[0]);
        }
    }
}

