/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.qenherkhopeshef.graphics.vectorClipboard.RTFPicture;
import org.qenherkhopeshef.graphics.vectorClipboard.RTFPictureUtils;

public class RTFTransferable
implements Transferable {
    public static final DataFlavor RTF_FLAVOR = new DataFlavor("text/rtf", null);
    private static final DataFlavor[] flavors = new DataFlavor[]{RTF_FLAVOR};
    private RTFPicture rtfPicture;

    public RTFTransferable(RTFPicture rtfPicture) {
        this.rtfPicture = rtfPicture;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (RTF_FLAVOR.equals(flavor)) {
            return new ByteArrayInputStream(RTFPictureUtils.createRTFByteArray(this.rtfPicture));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

