/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.qenherkhopeshef.graphics.vectorClipboard.PDFPicture;

public class PDFTransferable
implements Transferable {
    public static final DataFlavor PDF_FLAVOR = new DataFlavor("application/pdf", "PDF");
    private static final DataFlavor[] flavors = new DataFlavor[]{PDF_FLAVOR};
    private PDFPicture pdfPicture;

    public PDFTransferable(PDFPicture pdfPicture) {
        this.pdfPicture = pdfPicture;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(PDF_FLAVOR)) {
            return new ByteArrayInputStream(this.pdfPicture.getByteArray());
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        return Arrays.asList(flavors).contains(flavor);
    }

    static {
        ((SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap()).addUnencodedNativeForFlavor(PDF_FLAVOR, "PDF");
    }
}

