/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.bitmaps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import org.qenherkhopeshef.graphics.generic.BaseGraphics2D;
import org.qenherkhopeshef.graphics.generic.BaseGraphics2DException;

public class MultiFileGraphics
extends BaseGraphics2D {
    private Properties properties;
    private BaseGraphics2D g;
    private int pageNumber = 0;
    private Graphics2DFactory factory;
    private File directory;
    private String base;
    private String extension;

    public MultiFileGraphics(Graphics2DFactory factory, File directory, String base, String extension) {
        this.factory = factory;
        this.base = base;
        this.directory = directory;
        this.extension = extension;
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        if (this.g != null) {
            return this.g.create();
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.g != null) {
            this.g.dispose();
        }
    }

    @Override
    public void draw(Shape s) {
        this.g.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void fill(Shape s) {
        this.g.fill(s);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.g.getFontRenderContext();
    }

    @Override
    public void setPaintMode() {
        this.g.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.g.setXORMode(c1);
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void openPage(Dimension dimensions, String title) throws BaseGraphics2DException {
        try {
            String num = this.stringFormat(this.pageNumber + 1);
            File f = new File(this.directory, this.base + num + "." + this.extension);
            this.g = null;
            this.g = this.factory.createGraphics(f, this.pageNumber, dimensions);
            this.g.setProperties(this.properties);
            this.g.transform(this.getTransform());
            ++this.pageNumber;
        }
        catch (FileNotFoundException e) {
            throw new BaseGraphics2DException(e);
        }
    }

    @Override
    public void transform(AffineTransform Tx) {
        super.transform(Tx);
        if (this.g != null) {
            this.g.transform(Tx);
        }
    }

    private String stringFormat(int i) {
        return "" + i;
    }

    public static interface Graphics2DFactory {
        public BaseGraphics2D createGraphics(File var1, int var2, Dimension var3) throws FileNotFoundException;
    }
}

