/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.bitmaps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.qenherkhopeshef.graphics.bitmaps.GraphicsUtils;
import org.qenherkhopeshef.graphics.bitmaps.StreamGraphics2DDelegate;

public class BitmapStreamGraphics
extends StreamGraphics2DDelegate {
    OutputStream out;
    String format;
    BufferedImage image;

    public BitmapStreamGraphics(OutputStream out, Dimension2D dim, String format, boolean transparency) {
        this.format = format;
        this.out = out;
        int imageType = transparency ? 2 : 1;
        this.image = new BufferedImage((int)Math.ceil(dim.getWidth()), (int)Math.ceil(dim.getHeight()), imageType);
        this.proxy = (Graphics2D)this.image.getGraphics();
        GraphicsUtils.antialias(this.proxy);
    }

    public void fillWith(Color color) {
        Color oldColor = this.proxy.getBackground();
        this.proxy.setBackground(color);
        this.proxy.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
        this.proxy.setBackground(oldColor);
    }

    @Override
    public void dispose() {
        this.proxy.dispose();
        this.proxy = null;
        try {
            ImageIO.write((RenderedImage)this.image, this.format, this.out);
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.image = null;
        this.out = null;
    }

    @Override
    public void setProperties(Properties properties) {
    }
}

