/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.vio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.interpreter.Thrown;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmArray;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmThread;
import org.qbicc.interpreter.VmThrowableClass;
import org.qbicc.machine.vio.VIOSystem;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;

public final class VIO {
    private static final AttachmentKey<VIO> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final VIOSystem system;
    private final VmThrowableClass ioException;

    private VIO(CompilationContext ctxt) {
        this.ctxt = ctxt;
        this.system = new VIOSystem(256);
        this.ioException = (VmThrowableClass)ctxt.getBootstrapClassContext().findDefinedType("java/io/IOException").load().getVmClass();
        try {
            this.system.openInputStream(0, InputStream::nullInputStream);
            this.system.openOutputStream(1, OutputStream::nullOutputStream);
            this.system.openOutputStream(2, OutputStream::nullOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static VIO get(CompilationContext ctxt) {
        VIO instance = (VIO)ctxt.getAttachment(KEY);
        if (instance == null) {
            instance = new VIO(ctxt);
            VIO appearing = (VIO)ctxt.putAttachmentIfAbsent(KEY, (Object)instance);
            if (appearing != null) {
                instance = appearing;
            } else {
                instance.registerInvokables();
            }
        }
        return instance;
    }

    public VIOSystem getVIOSystem() {
        return this.system;
    }

    private void registerInvokables() {
        Vm vm = this.ctxt.getVm();
        ClassContext classContext = this.ctxt.getBootstrapClassContext();
        LoadedTypeDefinition hostIoDef = classContext.findDefinedType("org/qbicc/runtime/host/HostIO").load();
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("close"), this::doHostClose);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("pipe"), this::doHostPipe);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("socketpair"), this::doHostSocketPair);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("dup"), this::doHostDup);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("dup2"), this::doHostDup2);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("read"), this::doHostRead);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("pread"), this::doHostPRead);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("readSingle"), this::doHostReadSingle);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("available"), this::doHostAvailable);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("write"), this::doHostWrite);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("writeSingle"), this::doHostWriteSingle);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("getFileSize"), this::doHostGetFileSize);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("seekAbsolute"), this::doHostSeekAbsolute);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("seekRelative"), this::doHostSeekRelative);
    }

    private Object doHostClose(VmThread vmThread, VmObject ignored, List<Object> args) {
        int fd = (Integer)args.get(0);
        try {
            this.system.close(fd);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return null;
    }

    private Object doHostPipe(VmThread vmThread, VmObject ignored, List<Object> args) {
        int[] fds;
        try {
            fds = this.system.pipe();
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return vmThread.getVM().newIntArray(fds);
    }

    private Object doHostSocketPair(VmThread vmThread, VmObject ignored, List<Object> args) {
        int[] fds;
        try {
            fds = this.system.socketPair();
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return vmThread.getVM().newIntArray(fds);
    }

    private Object doHostDup(VmThread vmThread, VmObject ignored, List<Object> args) {
        int res;
        int fd = (Integer)args.get(0);
        try {
            res = this.system.dup(fd);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return res;
    }

    private Object doHostDup2(VmThread vmThread, VmObject ignored, List<Object> args) {
        int oldFd = (Integer)args.get(0);
        int newFd = (Integer)args.get(1);
        try {
            this.system.dup2(oldFd, newFd);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return null;
    }

    private Object doHostRead(VmThread vmThread, VmObject ignored, List<Object> args) {
        int res;
        int fd = (Integer)args.get(0);
        byte[] array = (byte[])((VmArray)args.get(1)).getArray();
        int off = (Integer)args.get(2);
        int len = (Integer)args.get(3);
        try {
            res = this.system.read(fd, ByteBuffer.wrap(array, off, len));
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return res;
    }

    private Object doHostPRead(VmThread vmThread, VmObject ignored, List<Object> args) {
        int res;
        int fd = (Integer)args.get(0);
        byte[] array = (byte[])((VmArray)args.get(1)).getArray();
        int off = (Integer)args.get(2);
        int len = (Integer)args.get(3);
        long position = (Long)args.get(4);
        try {
            res = this.system.pread(fd, ByteBuffer.wrap(array, off, len), position);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return res;
    }

    private Object doHostReadSingle(VmThread vmThread, VmObject ignored, List<Object> args) {
        int res;
        int fd = (Integer)args.get(0);
        try {
            res = this.system.readSingle(fd);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return res;
    }

    private Object doHostAvailable(VmThread vmThread, VmObject ignored, List<Object> args) {
        long res;
        int fd = (Integer)args.get(0);
        try {
            res = this.system.available(fd);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return res;
    }

    private Object doHostWrite(VmThread vmThread, VmObject ignored, List<Object> args) {
        int res;
        int fd = (Integer)args.get(0);
        byte[] array = (byte[])((VmArray)args.get(1)).getArray();
        int off = (Integer)args.get(2);
        int len = (Integer)args.get(3);
        try {
            res = this.system.write(fd, ByteBuffer.wrap(array, off, len));
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return res;
    }

    private Object doHostWriteSingle(VmThread vmThread, VmObject ignored, List<Object> args) {
        int fd = (Integer)args.get(0);
        int val = (Integer)args.get(0) & 0xFF;
        try {
            this.system.writeSingle(fd, val);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return null;
    }

    private Object doHostGetFileSize(VmThread vmThread, VmObject ignored, List<Object> args) {
        int fd = (Integer)args.get(0);
        try {
            return this.system.getFileSize(fd);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
    }

    private Object doHostSeekAbsolute(VmThread vmThread, VmObject ignored, List<Object> args) {
        int fd = (Integer)args.get(0);
        long offs = (Long)args.get(1);
        try {
            return this.system.seekAbsolute(fd, offs);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
    }

    private Object doHostSeekRelative(VmThread vmThread, VmObject ignored, List<Object> args) {
        int fd = (Integer)args.get(0);
        long offs = (Long)args.get(1);
        try {
            return this.system.seekRelative(fd, offs);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
    }

    private Thrown wrapIOE(IOException e) {
        return new Thrown(this.ioException.newInstance(e.getMessage()));
    }
}

