/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.trycatch;

import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.plugin.trycatch.ExceptionOnThreadBasicBlockBuilder;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeSignature;

public final class ExceptionOnThreadStrategy {
    static final String THREAD_INT_NAME = "java/lang/Thread";
    private static final String THROWABLE_INT_NAME = "java/lang/Throwable";

    private ExceptionOnThreadStrategy() {
    }

    public static void initialize(CompilationContext ctxt) {
        final ClassContext classContext = ctxt.getBootstrapClassContext();
        Patcher patcher = Patcher.get((CompilationContext)ctxt);
        final ClassTypeDescriptor throwableDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)THROWABLE_INT_NAME);
        patcher.addField(classContext, THREAD_INT_NAME, "thrown", (TypeDescriptor)throwableDesc, new FieldResolver(){

            public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
                builder.setModifiers(25165826);
                builder.setEnclosingType(enclosing);
                builder.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)throwableDesc));
                return builder.build();
            }
        }, 0, 0);
    }

    public static BasicBlockBuilder loweringBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        return new ExceptionOnThreadBasicBlockBuilder(delegate);
    }
}

